/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.tools;

import edu.duke.cs.osprey.tools.BigExp;
import edu.duke.cs.osprey.tools.MathTools;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.math.RoundingMode;

public class BigMath {
    public final MathContext context;
    private BigDecimal d = null;

    public BigMath(MathContext context) {
        this.context = context;
    }

    public BigMath(int precision) {
        this(new MathContext(precision, RoundingMode.HALF_UP));
    }

    public BigMath clear() {
        this.d = null;
        return this;
    }

    public BigDecimal get() {
        return this.d;
    }

    public BigMath set(BigDecimal val) {
        this.d = val;
        return this;
    }

    public BigMath set(BigExp val) {
        return this.set(val.toBigDecimal(this.context));
    }

    public BigMath set(BigInteger val) {
        return this.set(new BigDecimal(val));
    }

    public BigMath set(double val) {
        return this.set(MathTools.biggen(val));
    }

    public BigMath set(long val) {
        return this.set(MathTools.biggen(val));
    }

    public BigMath add(BigDecimal val) {
        this.d = MathTools.bigAdd(this.d, val, this.context);
        return this;
    }

    public BigMath add(BigExp val) {
        return this.add(val.toBigDecimal(this.context));
    }

    public BigMath add(BigInteger val) {
        return this.add(new BigDecimal(val));
    }

    public BigMath add(double val) {
        return this.add(MathTools.biggen(val));
    }

    public BigMath add(long val) {
        return this.add(MathTools.biggen(val));
    }

    public BigMath addOrSet(BigDecimal val) {
        if (this.d == null) {
            return this.set(val);
        }
        return this.add(val);
    }

    public BigMath addOrSet(BigExp val) {
        return this.addOrSet(val.toBigDecimal(this.context));
    }

    public BigMath addOrSet(BigInteger val) {
        return this.addOrSet(new BigDecimal(val));
    }

    public BigMath addOrSet(double val) {
        return this.addOrSet(MathTools.biggen(val));
    }

    public BigMath addOrSet(long val) {
        return this.addOrSet(MathTools.biggen(val));
    }

    public BigMath sub(BigDecimal val) {
        this.d = MathTools.bigSubtract(this.d, val, this.context);
        return this;
    }

    public BigMath sub(BigExp val) {
        return this.sub(val.toBigDecimal(this.context));
    }

    public BigMath sub(BigInteger val) {
        return this.sub(new BigDecimal(val));
    }

    public BigMath sub(double val) {
        return this.sub(MathTools.biggen(val));
    }

    public BigMath sub(long val) {
        return this.sub(MathTools.biggen(val));
    }

    public BigMath mult(BigDecimal val) {
        this.d = MathTools.bigMultiply(this.d, val, this.context);
        return this;
    }

    public BigMath mult(BigExp val) {
        return this.mult(val.toBigDecimal(this.context));
    }

    public BigMath mult(BigInteger val) {
        return this.mult(new BigDecimal(val));
    }

    public BigMath mult(double val) {
        return this.mult(MathTools.biggen(val));
    }

    public BigMath mult(long val) {
        return this.mult(MathTools.biggen(val));
    }

    public BigMath multOrSet(BigDecimal val) {
        if (this.d == null) {
            return this.set(val);
        }
        return this.mult(val);
    }

    public BigMath multOrSet(BigExp val) {
        return this.multOrSet(val.toBigDecimal(this.context));
    }

    public BigMath multOrSet(BigInteger val) {
        return this.multOrSet(new BigDecimal(val));
    }

    public BigMath multOrSet(double val) {
        return this.multOrSet(MathTools.biggen(val));
    }

    public BigMath multOrSet(long val) {
        return this.multOrSet(MathTools.biggen(val));
    }

    public BigMath div(BigDecimal val) {
        this.d = MathTools.bigDivide(this.d, val, this.context);
        return this;
    }

    public BigMath div(BigExp val) {
        return this.div(val.toBigDecimal(this.context));
    }

    public BigMath div(BigInteger val) {
        return this.div(new BigDecimal(val));
    }

    public BigMath div(double val) {
        return this.div(MathTools.biggen(val));
    }

    public BigMath div(long val) {
        return this.div(MathTools.biggen(val));
    }

    public BigMath recip() {
        this.d = MathTools.bigDivide(BigDecimal.ONE, this.d, this.context);
        return this;
    }

    public BigMath negate() {
        this.d = MathTools.bigNegate(this.d);
        return this;
    }

    public BigMath atLeast(BigDecimal val) {
        if (MathTools.isGreaterThan(val, this.d)) {
            this.d = val;
        }
        return this;
    }

    public BigMath atLeast(BigExp val) {
        return this.atLeast(val.toBigDecimal(this.context));
    }

    public BigMath atLeast(BigInteger val) {
        return this.atLeast(new BigDecimal(val));
    }

    public BigMath atLeast(double val) {
        return this.atLeast(MathTools.biggen(val));
    }

    public BigMath atLeast(long val) {
        return this.atLeast(MathTools.biggen(val));
    }

    public BigMath atMost(BigDecimal val) {
        if (MathTools.isLessThan(val, this.d)) {
            this.d = val;
        }
        return this;
    }

    public BigMath atMost(BigExp val) {
        return this.atMost(val.toBigDecimal(this.context));
    }

    public BigMath atMost(BigInteger val) {
        return this.atMost(new BigDecimal(val));
    }

    public BigMath atMost(double val) {
        return this.atMost(MathTools.biggen(val));
    }

    public BigMath atMost(long val) {
        return this.atMost(MathTools.biggen(val));
    }

    public BigMath min(BigDecimal val) {
        return this.atMost(val);
    }

    public BigMath min(BigExp val) {
        return this.min(val.toBigDecimal(this.context));
    }

    public BigMath min(BigInteger val) {
        return this.min(new BigDecimal(val));
    }

    public BigMath min(double val) {
        return this.min(MathTools.biggen(val));
    }

    public BigMath min(long val) {
        return this.min(MathTools.biggen(val));
    }

    public BigMath max(BigDecimal val) {
        return this.atLeast(val);
    }

    public BigMath max(BigExp val) {
        return this.max(val.toBigDecimal(this.context));
    }

    public BigMath max(BigInteger val) {
        return this.max(new BigDecimal(val));
    }

    public BigMath max(double val) {
        return this.max(MathTools.biggen(val));
    }

    public BigMath max(long val) {
        return this.max(MathTools.biggen(val));
    }

    public BigMath minOrSet(BigDecimal val) {
        if (this.d == null || MathTools.isLessThan(val, this.d)) {
            this.d = val;
        }
        return this;
    }

    public BigMath minOrSet(BigExp val) {
        return this.minOrSet(val.toBigDecimal(this.context));
    }

    public BigMath minOrSet(BigInteger val) {
        return this.minOrSet(new BigDecimal(val));
    }

    public BigMath minOrSet(double val) {
        return this.minOrSet(MathTools.biggen(val));
    }

    public BigMath minOrSet(long val) {
        return this.minOrSet(MathTools.biggen(val));
    }

    public BigMath maxOrSet(BigDecimal val) {
        if (this.d == null || MathTools.isGreaterThan(val, this.d)) {
            this.d = val;
        }
        return this;
    }

    public BigMath maxOrSet(BigExp val) {
        return this.maxOrSet(val.toBigDecimal(this.context));
    }

    public BigMath maxOrSet(BigInteger val) {
        return this.maxOrSet(new BigDecimal(val));
    }

    public BigMath maxOrSet(double val) {
        return this.maxOrSet(MathTools.biggen(val));
    }

    public BigMath maxOrSet(long val) {
        return this.maxOrSet(MathTools.biggen(val));
    }
}

