/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.tools;

import cern.colt.matrix.DoubleFactory1D;
import cern.colt.matrix.DoubleMatrix1D;
import cern.colt.matrix.DoubleMatrix2D;
import cern.colt.matrix.linalg.Algebra;
import cern.colt.matrix.linalg.EigenvalueDecomposition;
import java.io.Serializable;

public class EllipseTransform
implements Serializable {
    DoubleMatrix1D c;
    DoubleMatrix2D A;

    public EllipseTransform(DoubleMatrix2D mat, DoubleMatrix1D cent) {
        this.A = mat;
        this.c = cent;
    }

    public double[] getEllipsoidalCoords(double[] dihedrals) {
        if (dihedrals.length == 0) {
            return new double[0];
        }
        EigenvalueDecomposition evd = new EigenvalueDecomposition(this.A);
        DoubleMatrix2D Q = evd.getV();
        DoubleMatrix2D L = evd.getD();
        DoubleMatrix2D qT = Q.viewDice().copy();
        Algebra alg = new Algebra();
        double[] s = new double[dihedrals.length];
        for (int i = 0; i < dihedrals.length; ++i) {
            s[i] = dihedrals[i] - this.c.get(i);
        }
        double[] u = alg.mult(qT, DoubleFactory1D.dense.make(s)).toArray();
        double[] x = new double[u.length];
        for (int i = 0; i < u.length; ++i) {
            x[i] = u[i] / Math.sqrt(L.get(i, i));
        }
        dihedrals = x;
        double radius = 0.0;
        for (double d : dihedrals) {
            radius += d * d;
        }
        radius = Math.sqrt(radius);
        int n = dihedrals.length;
        double[] phi = new double[n - 1];
        for (int i = 0; i < n - 1; ++i) {
            double d;
            d = 0.0;
            for (int j = i; j < n; ++j) {
                d += dihedrals[j] * dihedrals[j];
            }
            double quot = dihedrals[i] / Math.sqrt(d);
            phi[i] = Math.acos(quot);
        }
        if (dihedrals[n - 1] < 0.0) {
            phi[n - 2] = Math.PI * 2 - phi[n - 2];
        }
        double[] ellCoords = new double[n];
        ellCoords[0] = radius;
        for (int i = 1; i < n; ++i) {
            ellCoords[i] = phi[i - 1];
        }
        return ellCoords;
    }

    public double[] getCartesianCoords(double[] polars) {
        if (polars.length == 0) {
            return new double[0];
        }
        EigenvalueDecomposition evd = new EigenvalueDecomposition(this.A);
        DoubleMatrix2D Q = evd.getV();
        DoubleMatrix2D L = evd.getD();
        DoubleMatrix2D qT = Q.viewDice().copy();
        Algebra alg = new Algebra();
        int n = polars.length;
        double radius = polars[0];
        double[] phis = new double[n - 1];
        for (int i = 1; i < n; ++i) {
            phis[i - 1] = polars[i];
        }
        double[] cartCoords = new double[n];
        for (int i = 0; i < n; ++i) {
            double prod = 1.0;
            for (int j = 0; j < i; ++j) {
                prod *= Math.sin(phis[j]);
            }
            if (i < n - 1) {
                prod *= Math.cos(phis[i]);
            }
            cartCoords[i] = radius * prod;
        }
        double[] u = new double[cartCoords.length];
        for (int i = 0; i < u.length; ++i) {
            u[i] = cartCoords[i] * Math.sqrt(L.get(i, i));
        }
        double[] s = alg.mult(Q, DoubleFactory1D.dense.make(u)).toArray();
        double[] x = new double[s.length];
        for (int i = 0; i < x.length; ++i) {
            x[i] = s[i] + this.c.get(i);
        }
        return x;
    }
}

