/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.tools;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public interface IOable {
    public void writeTo(DataOutput var1) throws IOException;

    public void readFrom(DataInput var1) throws IOException;

    default public void writeTo(File file) {
        try (FileOutputStream out = new FileOutputStream(file);){
            this.writeTo(new DataOutputStream(out));
        }
        catch (IOException ex) {
            throw new RuntimeException("can't write to file: " + file.getAbsolutePath(), ex);
        }
    }

    default public void readFrom(File file) {
        try (FileInputStream in = new FileInputStream(file);){
            this.readFrom(new DataInputStream(in));
        }
        catch (IOException ex) {
            throw new RuntimeException("can't read from file: " + file.getAbsolutePath(), ex);
        }
    }

    default public void writeToGZIP(File file) {
        try (FileOutputStream out = new FileOutputStream(file);){
            GZIPOutputStream gout = new GZIPOutputStream(out);
            this.writeTo(new DataOutputStream(gout));
            gout.finish();
        }
        catch (IOException ex) {
            throw new RuntimeException("can't write to file: " + file.getAbsolutePath(), ex);
        }
    }

    default public void readFromGZIP(File file) {
        try (FileInputStream in = new FileInputStream(file);){
            GZIPInputStream gin = new GZIPInputStream(in);
            this.readFrom(new DataInputStream(gin));
        }
        catch (IOException ex) {
            throw new RuntimeException("can't read from file: " + file.getAbsolutePath(), ex);
        }
    }

    public static IOable of(Object obj) {
        if (obj instanceof IOable) {
            return (IOable)obj;
        }
        throw new IllegalArgumentException("object " + obj.getClass().getSimpleName() + " is not IOable");
    }
}

