/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.tools;

import edu.duke.cs.osprey.kstar.pfunc.BoltzmannCalculator;
import edu.duke.cs.osprey.tools.MathTools;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.math.RoundingMode;

public class Log {
    public static void logf(String format, Object ... args) {
        System.out.print(String.format(format, args));
    }

    public static void log(String format, Object ... args) {
        System.out.println(String.format(format, args));
    }

    public static void log(StringBuilder buf, String format, Object ... args) {
        buf.append(String.format(format + "\n", args));
    }

    public static String formatBig(BigInteger i) {
        if (i == null) {
            return "null";
        }
        if (i.compareTo(BigInteger.valueOf(1000000L)) < 0) {
            return String.format("%s", i);
        }
        return String.format("%e", i.doubleValue());
    }

    public static String formatBig(BigDecimal f) {
        if (f == null) {
            return "null";
        }
        return String.format("%s (%.2f)", Log.formatBigEngineering(f), MathTools.log10p1(f));
    }

    public static String formatBigEngineering(MathTools.BigDecimalBounds f) {
        return String.format("[%s,%s]", Log.formatBigEngineering(f.lower), Log.formatBigEngineering(f.upper));
    }

    public static String formatBigEngineering(BigDecimal f) {
        if (f instanceof MathTools.MagicBigDecimal) {
            return f.toString();
        }
        return String.format("%e", f);
    }

    public static String formatBigLn(BigDecimal f) {
        if (f == null) {
            return "null";
        }
        if (MathTools.isZero(f)) {
            return "0";
        }
        MathContext mathContext = new MathContext(16, RoundingMode.HALF_UP);
        BoltzmannCalculator bcalc = new BoltzmannCalculator(mathContext);
        return String.format("%9.4f", bcalc.ln1p(f));
    }

    public static String formatBigLn(MathTools.BigDecimalBounds b) {
        if (b == null) {
            return "null";
        }
        return String.format("[%-9s,%9s]", Log.formatBigLn(b.lower), Log.formatBigLn(b.upper));
    }
}

