/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.tools;

import ch.obermuhlner.math.big.BigDecimalMath;
import edu.duke.cs.osprey.tools.BigMath;
import edu.duke.cs.osprey.tools.HashCalculator;
import edu.duke.cs.osprey.tools.Log;
import edu.duke.cs.osprey.tools.UnpossibleError;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public class MathTools {
    public static final BigDecimal BigPositiveInfinity = new MagicBigDecimal(Double.POSITIVE_INFINITY);
    public static final BigDecimal BigNegativeInfinity = new MagicBigDecimal(Double.NEGATIVE_INFINITY);
    public static final BigDecimal BigNaN = new MagicBigDecimal(Double.NaN);

    public static int divUp(int num, int denom) {
        return (num + denom - 1) / denom;
    }

    public static int roundUpToMultiple(int val, int base) {
        int mod = val % base;
        if (mod == 0) {
            return val;
        }
        return val + base - mod;
    }

    public static <T> List<List<T>> powerset(List<T> list) {
        return MathTools.powersetUpTo(list, list.size());
    }

    public static <T> List<List<T>> powersetUpTo(List<T> list, int size) {
        ArrayList<List<T>> powerset = new ArrayList<List<T>>();
        powerset.add(new ArrayList());
        for (T item : list) {
            for (List<T> subset : new ArrayList<List<T>>(powerset)) {
                if (subset.size() >= size) continue;
                ArrayList<T> newSubset = new ArrayList<T>(subset);
                newSubset.add(item);
                powerset.add(newSubset);
            }
        }
        return powerset;
    }

    public static <T> Iterable<List<T>> cartesianProduct(final List<List<T>> lists) {
        return () -> new Iterator<List<T>>(){
            private final int n;
            private boolean hasNext;
            private final int[] lengths;
            private final int[] indices;
            {
                this.n = lists.size();
                this.hasNext = this.n > 0;
                this.lengths = new int[this.n];
                for (int i = 0; i < this.n; ++i) {
                    this.lengths[i] = ((List)lists.get(i)).size();
                    if (this.lengths[i] > 0) continue;
                    this.hasNext = false;
                }
                this.indices = new int[this.n];
                Arrays.fill(this.indices, 0);
            }

            @Override
            public boolean hasNext() {
                return this.hasNext;
            }

            @Override
            public List<T> next() {
                int i;
                ArrayList result = new ArrayList();
                for (i = 0; i < this.n; ++i) {
                    result.add(((List)lists.get(i)).get(this.indices[i]));
                }
                for (i = this.n - 1; i >= 0; --i) {
                    if (this.indices[i] == this.lengths[i] - 1) {
                        this.indices[i] = 0;
                        if (i != 0) continue;
                        this.hasNext = false;
                        continue;
                    }
                    int n = i;
                    this.indices[n] = this.indices[n] + 1;
                    break;
                }
                return result;
            }
        };
    }

    public static boolean isZero(BigInteger i) {
        return i.compareTo(BigInteger.ZERO) == 0;
    }

    public static BigDecimal biggen(double val) {
        if (val == Double.POSITIVE_INFINITY) {
            return BigPositiveInfinity;
        }
        if (val == Double.NEGATIVE_INFINITY) {
            return BigNegativeInfinity;
        }
        if (Double.isNaN(val)) {
            return BigNaN;
        }
        if (val == 0.0) {
            return BigDecimal.ZERO;
        }
        if (val == 1.0) {
            return BigDecimal.ONE;
        }
        return BigDecimal.valueOf(val);
    }

    public static BigDecimal biggen(long val) {
        return new BigDecimal(val);
    }

    public static BigDecimal biggen(String val) {
        return new BigDecimal(val);
    }

    public static BigDecimalBounds biggen(double lower, double upper) {
        return new BigDecimalBounds(MathTools.biggen(lower), MathTools.biggen(upper));
    }

    public static BigDecimalBounds biggen(String lower, String upper) {
        return new BigDecimalBounds(MathTools.biggen(lower), MathTools.biggen(upper));
    }

    public static int compare(BigDecimal a, BigDecimal b) {
        if (a == BigNaN || b == BigNaN) {
            throw new IllegalArgumentException("can't compare NaN");
        }
        if (a == BigPositiveInfinity) {
            if (b == BigPositiveInfinity) {
                return 0;
            }
            return 1;
        }
        if (a == BigNegativeInfinity) {
            if (b == BigNegativeInfinity) {
                return 0;
            }
            return -1;
        }
        if (b == BigPositiveInfinity) {
            return -1;
        }
        if (b == BigNegativeInfinity) {
            return 1;
        }
        return a.compareTo(b);
    }

    public static boolean isSameValue(BigDecimal a, BigDecimal b) {
        return a == b || MathTools.compare(a, b) == 0;
    }

    public static boolean isAbsolutelySame(BigDecimal a, BigDecimal b, double epsilon) {
        return a == b || a.subtract(b).abs().doubleValue() <= epsilon;
    }

    public static boolean isRelativelySame(BigDecimal a, BigDecimal b, MathContext context, double epsilon) {
        if (a == b) {
            return true;
        }
        if (a instanceof MagicBigDecimal || b instanceof MagicBigDecimal) {
            return false;
        }
        BigDecimal numerator = a.subtract(b).abs();
        BigDecimal denominator = a.abs();
        if (MathTools.isZero(numerator) && MathTools.isZero(denominator)) {
            return true;
        }
        if (MathTools.isZero(numerator)) {
            return true;
        }
        if (MathTools.isZero(denominator)) {
            return false;
        }
        return numerator.divide(denominator, context).doubleValue() <= epsilon;
    }

    public static boolean isZero(BigDecimal d) {
        return d == BigDecimal.ZERO || MathTools.isFinite(d) && d.compareTo(BigDecimal.ZERO) == 0;
    }

    public static boolean isPositive(BigDecimal d) {
        if (d == BigPositiveInfinity) {
            return true;
        }
        if (d == BigNegativeInfinity) {
            return false;
        }
        if (d == BigNaN) {
            return false;
        }
        return MathTools.isGreaterThan(d, BigDecimal.ZERO);
    }

    public static boolean isNegative(BigDecimal d) {
        if (d == BigPositiveInfinity) {
            return false;
        }
        if (d == BigNegativeInfinity) {
            return true;
        }
        if (d == BigNaN) {
            return false;
        }
        return MathTools.isLessThan(d, BigDecimal.ZERO);
    }

    public static boolean isInf(BigDecimal d) {
        return d == BigPositiveInfinity || d == BigNegativeInfinity;
    }

    public static boolean isFinite(BigDecimal d) {
        return !MathTools.isInf(d) && !MathTools.isNaN(d);
    }

    public static boolean isNaN(BigDecimal d) {
        return d == BigNaN;
    }

    public static boolean isLessThan(BigDecimal a, BigDecimal b) {
        return MathTools.compare(a, b) == -1;
    }

    public static boolean isLessThanOrEqual(BigDecimal a, BigDecimal b) {
        return MathTools.isLessThan(a, b) || MathTools.isSameValue(a, b);
    }

    public static boolean isGreaterThan(BigDecimal a, BigDecimal b) {
        return MathTools.compare(a, b) == 1;
    }

    public static boolean isGreaterThanOrEqual(BigDecimal a, BigDecimal b) {
        return MathTools.isGreaterThan(a, b) || MathTools.isSameValue(a, b);
    }

    public static BigDecimal bigNegate(BigDecimal a) {
        if (a == BigNaN) {
            return BigNaN;
        }
        if (a == BigNegativeInfinity) {
            return BigPositiveInfinity;
        }
        if (a == BigPositiveInfinity) {
            return BigNegativeInfinity;
        }
        return a.negate();
    }

    public static BigDecimal bigAdd(BigDecimal a, BigDecimal b, MathContext context) {
        if (a == BigNaN || b == BigNaN) {
            return BigNaN;
        }
        if (a == BigPositiveInfinity) {
            if (b == BigNegativeInfinity) {
                return BigNaN;
            }
            return BigPositiveInfinity;
        }
        if (a == BigNegativeInfinity) {
            if (b == BigPositiveInfinity) {
                return BigNaN;
            }
            return BigNegativeInfinity;
        }
        if (b == BigPositiveInfinity) {
            return BigPositiveInfinity;
        }
        if (b == BigNegativeInfinity) {
            return BigNegativeInfinity;
        }
        return a.add(b, context);
    }

    public static BigDecimal bigSubtract(BigDecimal a, BigDecimal b, MathContext context) {
        if (a == BigNaN || b == BigNaN) {
            return BigNaN;
        }
        if (a == BigPositiveInfinity) {
            if (b == BigPositiveInfinity) {
                return BigNaN;
            }
            return BigPositiveInfinity;
        }
        if (a == BigNegativeInfinity) {
            if (b == BigNegativeInfinity) {
                return BigNaN;
            }
            return BigNegativeInfinity;
        }
        if (b == BigPositiveInfinity) {
            return BigNegativeInfinity;
        }
        if (b == BigNegativeInfinity) {
            return BigPositiveInfinity;
        }
        return a.subtract(b, context);
    }

    public static BigDecimal bigMultiply(BigDecimal a, BigDecimal b, MathContext context) {
        if (a == BigNaN) {
            return BigNaN;
        }
        if (a == BigPositiveInfinity) {
            if (b == BigNaN || b == BigNegativeInfinity) {
                return BigNaN;
            }
            if (b == BigPositiveInfinity) {
                return BigPositiveInfinity;
            }
            int cmp = b.compareTo(BigDecimal.ZERO);
            if (cmp == 0) {
                return BigDecimal.ZERO;
            }
            if (cmp > 0) {
                return BigPositiveInfinity;
            }
            return BigNegativeInfinity;
        }
        if (a == BigNegativeInfinity) {
            if (b == BigNaN || b == BigPositiveInfinity) {
                return BigNaN;
            }
            if (b == BigNegativeInfinity) {
                return BigPositiveInfinity;
            }
            int cmp = b.compareTo(BigDecimal.ZERO);
            if (cmp == 0) {
                return BigDecimal.ZERO;
            }
            if (cmp > 0) {
                return BigNegativeInfinity;
            }
            return BigPositiveInfinity;
        }
        if (b == BigNaN) {
            return BigNaN;
        }
        if (b == BigPositiveInfinity) {
            int cmp = a.compareTo(BigDecimal.ZERO);
            if (cmp == 0) {
                return BigDecimal.ZERO;
            }
            if (cmp > 0) {
                return BigPositiveInfinity;
            }
            return BigNegativeInfinity;
        }
        if (b == BigNegativeInfinity) {
            int cmp = a.compareTo(BigDecimal.ZERO);
            if (cmp == 0) {
                return BigDecimal.ZERO;
            }
            if (cmp > 0) {
                return BigNegativeInfinity;
            }
            return BigPositiveInfinity;
        }
        try {
            return a.multiply(b, context);
        }
        catch (ArithmeticException ex) {
            if (ex.getMessage().equals("Underflow")) {
                return BigDecimal.ZERO;
            }
            throw ex;
        }
    }

    public static BigDecimal bigDivide(BigDecimal a, BigDecimal b, MathContext context) {
        if (a == BigNaN || b == BigNaN) {
            return BigNaN;
        }
        if (a == BigPositiveInfinity) {
            if (MathTools.isInf(b)) {
                return BigNaN;
            }
            if (b.signum() >= 0) {
                return BigPositiveInfinity;
            }
            return BigNegativeInfinity;
        }
        if (a == BigNegativeInfinity) {
            if (MathTools.isInf(b)) {
                return BigNaN;
            }
            if (b.signum() >= 0) {
                return BigNegativeInfinity;
            }
            return BigPositiveInfinity;
        }
        if (MathTools.isInf(b)) {
            return BigDecimal.ZERO;
        }
        if (MathTools.isZero(a) && MathTools.isZero(b)) {
            return BigNaN;
        }
        if (MathTools.isZero(b)) {
            return BigPositiveInfinity;
        }
        return a.divide(b, context);
    }

    public static BigDecimal bigDivideDivide(BigDecimal a, BigDecimal b, BigDecimal c, MathContext context) {
        return MathTools.bigDivide(MathTools.bigDivide(a, b, context), c, context);
    }

    public static double log10(BigDecimal x) {
        if (x == BigPositiveInfinity) {
            return Double.POSITIVE_INFINITY;
        }
        if (x == BigNaN || MathTools.isLessThan(x, BigDecimal.ZERO)) {
            return Double.NaN;
        }
        if (MathTools.isZero(x)) {
            return Double.NEGATIVE_INFINITY;
        }
        MathContext mc = new MathContext(16);
        return BigDecimalMath.log10((BigDecimal)x, (MathContext)mc).doubleValue();
    }

    public static double log10p1(BigDecimal x) {
        if (x == BigPositiveInfinity) {
            return Double.POSITIVE_INFINITY;
        }
        if (x == BigNegativeInfinity || x == BigNaN) {
            return Double.NaN;
        }
        MathContext mc = new MathContext(16);
        return BigDecimalMath.log10((BigDecimal)x.add(BigDecimal.ONE, mc), (MathContext)mc).doubleValue();
    }

    public static double log10p1(double x) {
        return Math.log10(x + 1.0);
    }

    public static String formatBytes(long bytes) {
        if (bytes < 1024L) {
            return String.format("%d B", bytes);
        }
        double kibibytes = (double)bytes / 1024.0;
        if (kibibytes < 128.0) {
            return String.format("%.1f KiB", kibibytes);
        }
        if (kibibytes < 1024.0) {
            return String.format("%.0f KiB", kibibytes);
        }
        double mebibytes = kibibytes / 1024.0;
        if (mebibytes < 128.0) {
            return String.format("%.1f MiB", mebibytes);
        }
        if (mebibytes < 1024.0) {
            return String.format("%.0f MiB", mebibytes);
        }
        double gibibytes = mebibytes / 1024.0;
        if (gibibytes < 128.0) {
            return String.format("%.1f GiB", gibibytes);
        }
        if (gibibytes < 1024.0) {
            return String.format("%.0f GiB", gibibytes);
        }
        double tebibytes = gibibytes / 1024.0;
        if (tebibytes < 128.0) {
            return String.format("%.1f TiB", tebibytes);
        }
        if (tebibytes < 1024.0) {
            return String.format("%.0f TiB", tebibytes);
        }
        double pebibytes = tebibytes / 1024.0;
        if (pebibytes < 128.0) {
            return String.format("%.1f PiB", pebibytes);
        }
        return String.format("%.0f PiB", pebibytes);
    }

    public static int numPairsPerSingle(int n) {
        return n - 1;
    }

    public static int numTriplesPerSingle(int n) {
        return (n - 1) * (n - 2) / 2;
    }

    public static int numTriplesPerPair(int n) {
        return n - 2;
    }

    public static int numQuadsPerSingle(int n) {
        return (n - 1) * (n - 2) * (n - 3) / 3 / 2;
    }

    public static int numQuadsPerPair(int n) {
        return (n - 2) * (n - 3) / 2;
    }

    public static class BigDecimalBounds {
        public BigDecimal lower;
        public BigDecimal upper;

        public BigDecimalBounds() {
            this(BigNegativeInfinity, BigPositiveInfinity);
        }

        public BigDecimalBounds(BigDecimalBounds other) {
            this(other.lower, other.upper);
        }

        public BigDecimalBounds(BigDecimal lower, BigDecimal upper) {
            this.lower = lower;
            this.upper = upper;
        }

        public BigDecimalBounds(BigDecimal val) {
            this(val, val);
        }

        public BigDecimalBounds(double lower, double upper) {
            this(MathTools.biggen(lower), MathTools.biggen(upper));
        }

        public BigDecimalBounds(String lower, String upper) {
            this(MathTools.biggen(lower), MathTools.biggen(upper));
        }

        public BigDecimal size(MathContext mathContext) {
            return new BigMath(mathContext).set(this.upper).sub(this.lower).get();
        }

        public boolean isValid() {
            return MathTools.isGreaterThanOrEqual(this.upper, this.lower);
        }

        public boolean contains(BigDecimal d) {
            return MathTools.isGreaterThanOrEqual(d, this.lower) && MathTools.isLessThanOrEqual(d, this.upper);
        }

        public boolean contains(BigDecimalBounds d) {
            return MathTools.isGreaterThanOrEqual(d.lower, this.lower) && MathTools.isLessThanOrEqual(d.upper, this.upper);
        }

        public boolean intersects(BigDecimalBounds other) {
            return MathTools.isGreaterThanOrEqual(this.upper, other.lower) && MathTools.isLessThanOrEqual(this.lower, other.upper);
        }

        public boolean equals(Object other) {
            return other instanceof BigDecimalBounds && this.equals((BigDecimalBounds)other);
        }

        public boolean equals(BigDecimalBounds other) {
            return MathTools.isSameValue(this.lower, other.lower) && MathTools.isSameValue(this.upper, other.upper);
        }

        public int hashCode() {
            return HashCalculator.combineHashes(this.lower.hashCode(), this.upper.hashCode());
        }

        public String toString() {
            return String.format("[%s,%s]", Log.formatBigEngineering(this.lower), Log.formatBigEngineering(this.upper));
        }

        public boolean isZero() {
            return MathTools.isZero(this.lower) && MathTools.isZero(this.upper);
        }

        public static BigDecimalBounds makeZero() {
            return new BigDecimalBounds(BigDecimal.ZERO, BigDecimal.ZERO);
        }
    }

    public static class MagicBigDecimal
    extends BigDecimal {
        public final double doubleValue;

        public MagicBigDecimal(double doubleValue) {
            super(new BigInteger("1"), Integer.MAX_VALUE);
            this.doubleValue = doubleValue;
        }

        @Override
        public double doubleValue() {
            return this.doubleValue;
        }

        @Override
        public String toString() {
            return Double.toString(this.doubleValue);
        }

        @Override
        public BigDecimal add(BigDecimal other) {
            throw new DontDoRawMathWithMagicException();
        }

        @Override
        public BigDecimal add(BigDecimal other, MathContext context) {
            throw new DontDoRawMathWithMagicException();
        }

        @Override
        public BigDecimal subtract(BigDecimal other) {
            throw new DontDoRawMathWithMagicException();
        }

        @Override
        public BigDecimal subtract(BigDecimal other, MathContext context) {
            throw new DontDoRawMathWithMagicException();
        }

        @Override
        public BigDecimal multiply(BigDecimal other) {
            throw new DontDoRawMathWithMagicException();
        }

        @Override
        public BigDecimal multiply(BigDecimal other, MathContext context) {
            throw new DontDoRawMathWithMagicException();
        }

        @Override
        public BigDecimal divide(BigDecimal other) {
            throw new DontDoRawMathWithMagicException();
        }

        @Override
        public BigDecimal divide(BigDecimal other, MathContext context) {
            throw new DontDoRawMathWithMagicException();
        }

        @Override
        public BigDecimal divide(BigDecimal divisor, int scale, int roundingMode) {
            throw new DontDoRawMathWithMagicException();
        }

        @Override
        public int precision() {
            throw new DontDoRawMathWithMagicException();
        }

        @Override
        public int scale() {
            throw new DontDoRawMathWithMagicException();
        }

        @Override
        public int signum() {
            throw new DontDoRawMathWithMagicException();
        }

        @Override
        public boolean equals(Object other) {
            return this == other;
        }

        public static class DontDoRawMathWithMagicException
        extends UnsupportedOperationException {
        }
    }

    public static class GridIterable
    implements Iterable<int[]> {
        public final int[] dimensions;

        public GridIterable(int[] dimensions) {
            for (int d : dimensions) {
                if (d > 0) continue;
                throw new IllegalArgumentException("invalid dimensions: " + Arrays.toString(dimensions));
            }
            this.dimensions = dimensions;
        }

        @Override
        public Iterator<int[]> iterator() {
            return new Iterator<int[]>(){
                int[] indices;
                boolean hasNext;
                {
                    this.indices = new int[dimensions.length];
                    this.hasNext = true;
                    Arrays.fill(this.indices, 0);
                    this.indices[0] = -1;
                }

                @Override
                public boolean hasNext() {
                    return this.hasNext;
                }

                @Override
                public int[] next() {
                    int d;
                    if (!this.hasNext) {
                        throw new NoSuchElementException();
                    }
                    this.indices[0] = this.indices[0] + 1;
                    for (d = 0; d < dimensions.length; ++d) {
                        if (this.indices[d] < dimensions[d]) continue;
                        if (d + 1 == dimensions.length) {
                            throw new UnpossibleError();
                        }
                        this.indices[d] = 0;
                        int n = d + 1;
                        this.indices[n] = this.indices[n] + 1;
                    }
                    this.hasNext = false;
                    for (d = 0; d < dimensions.length; ++d) {
                        if (this.indices[d] >= dimensions[d] - 1) continue;
                        this.hasNext = true;
                        break;
                    }
                    return this.indices;
                }
            };
        }
    }

    public static class BigIntegerBounds {
        public BigInteger lower;
        public BigInteger upper;

        public BigIntegerBounds(BigInteger lower, BigInteger upper) {
            this.lower = lower;
            this.upper = upper;
        }

        public String toString() {
            return String.format("[%d,%d]", this.lower, this.upper);
        }
    }

    public static class DoubleBounds {
        public double lower;
        public double upper;

        public DoubleBounds() {
            this(Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
        }

        public DoubleBounds(double lower, double upper) {
            this.lower = lower;
            this.upper = upper;
        }

        public void expand(double p) {
            this.lower = Math.min(this.lower, p);
            this.upper = Math.max(this.upper, p);
        }

        public double size() {
            return this.upper - this.lower;
        }

        public boolean isValid() {
            return this.lower <= this.upper;
        }

        public boolean isFinite() {
            return Double.isFinite(this.lower) && Double.isFinite(this.upper);
        }

        public boolean contains(double val) {
            return val >= this.lower && val <= this.upper;
        }

        public boolean contains(DoubleBounds val) {
            return val.lower >= this.lower && val.upper <= this.upper;
        }

        public boolean intersects(DoubleBounds other) {
            return other.upper >= this.lower && other.lower <= this.upper;
        }

        public int hashCode() {
            return HashCalculator.combineHashes(Double.hashCode(this.lower), Double.hashCode(this.upper));
        }

        public boolean equals(Object other) {
            return other instanceof DoubleBounds && this.equals((DoubleBounds)other);
        }

        public boolean equals(DoubleBounds other) {
            return this.lower == other.lower && this.upper == other.upper;
        }

        public String toString() {
            return this.toString(null, null);
        }

        public String toString(int precision) {
            return this.toString(precision, null);
        }

        public String toString(Integer precision, Integer width) {
            String spec = "%" + String.valueOf(width != null ? width : "") + (String)(precision != null ? "." + precision : "") + "f";
            return String.format("[" + spec + "," + spec + "]", this.lower, this.upper);
        }
    }

    public static enum Optimizer {
        Minimize{

            @Override
            public float initFloat() {
                return Float.POSITIVE_INFINITY;
            }

            @Override
            public double initDouble() {
                return Double.POSITIVE_INFINITY;
            }

            @Override
            public int initInt() {
                return Integer.MAX_VALUE;
            }

            @Override
            public long initLong() {
                return Long.MAX_VALUE;
            }

            @Override
            public BigDecimal initBigDecimal() {
                return BigPositiveInfinity;
            }

            @Override
            public boolean isBetter(float newval, float oldval) {
                return newval < oldval;
            }

            @Override
            public boolean isBetter(double newval, double oldval) {
                return newval < oldval;
            }

            @Override
            public boolean isBetter(int newval, int oldval) {
                return newval < oldval;
            }

            @Override
            public boolean isBetter(long newval, long oldval) {
                return newval < oldval;
            }

            @Override
            public boolean isBetter(BigDecimal newval, BigDecimal oldval) {
                return MathTools.isLessThan(newval, oldval);
            }

            @Override
            public Optimizer reverse() {
                return Maximize;
            }
        }
        ,
        Maximize{

            @Override
            public float initFloat() {
                return Float.NEGATIVE_INFINITY;
            }

            @Override
            public double initDouble() {
                return Double.NEGATIVE_INFINITY;
            }

            @Override
            public int initInt() {
                return Integer.MIN_VALUE;
            }

            @Override
            public long initLong() {
                return Long.MIN_VALUE;
            }

            @Override
            public BigDecimal initBigDecimal() {
                return BigNegativeInfinity;
            }

            @Override
            public boolean isBetter(float newval, float oldval) {
                return newval > oldval;
            }

            @Override
            public boolean isBetter(double newval, double oldval) {
                return newval > oldval;
            }

            @Override
            public boolean isBetter(int newval, int oldval) {
                return newval > oldval;
            }

            @Override
            public boolean isBetter(long newval, long oldval) {
                return newval > oldval;
            }

            @Override
            public boolean isBetter(BigDecimal newval, BigDecimal oldval) {
                return MathTools.isGreaterThan(newval, oldval);
            }

            @Override
            public Optimizer reverse() {
                return Minimize;
            }
        };


        public abstract float initFloat();

        public abstract double initDouble();

        public abstract int initInt();

        public abstract long initLong();

        public abstract BigDecimal initBigDecimal();

        public float opt(float a, float b) {
            return this.isBetter(a, b) ? a : b;
        }

        public double opt(double a, double b) {
            return this.isBetter(a, b) ? a : b;
        }

        public int opt(int a, int b) {
            return this.isBetter(a, b) ? a : b;
        }

        public long opt(long a, long b) {
            return this.isBetter(a, b) ? a : b;
        }

        public BigDecimal opt(BigDecimal a, BigDecimal b) {
            return this.isBetter(a, b) ? a : b;
        }

        public abstract boolean isBetter(float var1, float var2);

        public abstract boolean isBetter(double var1, double var3);

        public abstract boolean isBetter(int var1, int var2);

        public abstract boolean isBetter(long var1, long var3);

        public abstract boolean isBetter(BigDecimal var1, BigDecimal var2);

        public abstract Optimizer reverse();
    }
}

