/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.tools;

import edu.duke.cs.osprey.tools.Factory;
import java.io.Closeable;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Iterator;

public class ObjectPool<T>
implements Iterable<T> {
    private Factory<T, Void> factory;
    private Deque<T> objects;
    private int size;

    public ObjectPool(Factory<T, Void> factory) {
        this.factory = factory;
        this.objects = new ArrayDeque<T>();
        this.size = 0;
    }

    public void allocate(int size) {
        while (this.size < size) {
            this.make();
        }
    }

    private void make() {
        this.objects.addLast(this.factory.make(null));
        ++this.size;
    }

    public T checkout() {
        if (this.objects.isEmpty()) {
            this.make();
        }
        return this.objects.removeFirst();
    }

    public void release(T obj) {
        this.objects.addLast(obj);
    }

    public int size() {
        return this.size;
    }

    public int available() {
        return this.objects.size();
    }

    public void clear() {
        this.objects.clear();
    }

    @Override
    public Iterator<T> iterator() {
        return this.objects.iterator();
    }

    public Checkout<T> autoCheckout() {
        return new Checkout(this);
    }

    public static class Checkout<T>
    implements Closeable {
        private ObjectPool<T> pool;
        private final T thing;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Checkout(ObjectPool<T> pool) {
            this.pool = pool;
            ObjectPool<T> objectPool = pool;
            synchronized (objectPool) {
                this.thing = pool.checkout();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() {
            ObjectPool<T> objectPool = this.pool;
            synchronized (objectPool) {
                this.pool.release(this.thing);
            }
        }

        public T get() {
            return this.thing;
        }
    }
}

