/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.tools;

import edu.duke.cs.osprey.tools.JvmMem;
import edu.duke.cs.osprey.tools.Stopwatch;
import edu.duke.cs.osprey.tools.TimeFormatter;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Iterator;

public class Progress {
    private static final long NSpMS = 1000000L;
    private static final int UpdateIntervalMs = 500;
    private static final int MaxLogSize = 120;
    private static final Model DefaultModel = Model.Linear;
    private static final int DefaultReportIntervalMs = 5000;
    private long totalWork;
    private long reportIntervalMs;
    private Model model;
    private long currentWork;
    private Stopwatch stopwatch;
    private Deque<Long> workLog;
    private Deque<Long> timeMsLog;
    private long lastReportMs;
    private boolean reportMemory;

    public Progress(long totalWork) {
        this(totalWork, 5000L, DefaultModel);
    }

    public Progress(long totalWork, long reportIntervalMs) {
        this(totalWork, reportIntervalMs, DefaultModel);
    }

    public Progress(long totalWork, long reportIntervalMs, Model model) {
        this.totalWork = totalWork;
        this.reportIntervalMs = reportIntervalMs;
        this.model = model;
        this.currentWork = 0L;
        this.stopwatch = new Stopwatch();
        this.workLog = new ArrayDeque<Long>();
        this.timeMsLog = new ArrayDeque<Long>();
        this.lastReportMs = 0L;
        this.reportMemory = false;
        this.stopwatch.start();
        this.addLog(0L, 0L);
    }

    public void setReportMemory(boolean val) {
        this.reportMemory = val;
    }

    public long getNumWorkDone() {
        return this.currentWork;
    }

    public long getTotalWork() {
        return this.totalWork;
    }

    public void setTotalWork(long val) {
        this.totalWork = val;
    }

    public boolean isFinished() {
        return this.currentWork == this.totalWork;
    }

    public boolean setProgress(long currentWork) {
        boolean shouldReport;
        this.currentWork = currentWork;
        long elapsedMs = this.stopwatch.getTimeNs() / 1000000L;
        boolean update2 = elapsedMs - this.timeMsLog.getLast() >= 500L;
        boolean bl = shouldReport = elapsedMs - this.lastReportMs >= this.reportIntervalMs;
        if (this.isFinished()) {
            this.stopwatch.stop();
            update2 = true;
            shouldReport = true;
        }
        if (update2) {
            this.addLog(currentWork, elapsedMs);
        }
        if (shouldReport) {
            long etaMs = this.model.getEtaMs(this.workLog, this.timeMsLog, this.totalWork);
            if (etaMs < 0L) {
                etaMs = 0L;
            }
            System.out.print(String.format("Progress: %6.1f%%   ETA: %s", 100.0 * (double)currentWork / (double)this.totalWork, TimeFormatter.format(etaMs * 1000000L, 1)));
            if (this.reportMemory) {
                System.out.printf("   heapMem:%s", JvmMem.getOldPool());
            }
            System.out.println();
            this.lastReportMs = elapsedMs;
        }
        if (update2) {
            this.pruneLog();
        }
        if (currentWork == this.totalWork) {
            System.out.println("Finished in " + TimeFormatter.format(this.stopwatch.getTimeNs(), 1));
        }
        return shouldReport;
    }

    public boolean incrementProgress() {
        return this.incrementProgress(1L);
    }

    public boolean incrementProgress(long numWorkDone) {
        return this.setProgress(this.currentWork + numWorkDone);
    }

    public long getTimeNs() {
        return this.stopwatch.getTimeNs();
    }

    private void addLog(long work, long timeMs) {
        this.workLog.add(work);
        this.timeMsLog.add(timeMs);
    }

    private void pruneLog() {
        while (this.workLog.size() > 120) {
            this.workLog.removeFirst();
            this.timeMsLog.removeFirst();
        }
        assert (this.workLog.size() == this.timeMsLog.size());
    }

    public static enum Model {
        Linear{

            @Override
            public long getEtaMs(Deque<Long> workLog, Deque<Long> timeMsLog, long totalWork) {
                if (workLog.size() < 2) {
                    return -1L;
                }
                double sumxy = 0.0;
                double sumx = 0.0;
                double sumy = 0.0;
                double sumxsq = 0.0;
                Iterator<Long> workIter = workLog.iterator();
                Iterator<Long> timeIter = timeMsLog.iterator();
                while (workIter.hasNext()) {
                    long work = workIter.next();
                    long timeMs = timeIter.next();
                    sumxy += (double)(work * timeMs);
                    sumx += (double)work;
                    sumy += (double)timeMs;
                    sumxsq += (double)(work * work);
                }
                double a = (sumxy - sumx * sumy / (double)workLog.size()) / (sumxsq - sumx * sumx / (double)workLog.size());
                double b = (sumy - a * sumx) / (double)workLog.size();
                double x = totalWork;
                return (long)(a * x + b) - timeMsLog.getLast();
            }
        }
        ,
        Quadratic{

            @Override
            public long getEtaMs(Deque<Long> workLog, Deque<Long> timeMsLog, long totalWork) {
                if (workLog.size() < 2) {
                    return -1L;
                }
                double s00 = workLog.size();
                double s10 = 0.0;
                double s20 = 0.0;
                double s30 = 0.0;
                double s40 = 0.0;
                double s01 = 0.0;
                double s11 = 0.0;
                double s21 = 0.0;
                Iterator<Long> workIter = workLog.iterator();
                Iterator<Long> timeIter = timeMsLog.iterator();
                while (workIter.hasNext()) {
                    long work = workIter.next();
                    long timeMs = timeIter.next();
                    double x = work;
                    double y = timeMs;
                    s10 += x;
                    s01 += y;
                    s11 += x * y;
                    s20 += (x *= (double)work);
                    s21 += x * y;
                    s30 += (x *= (double)work);
                    s40 += (x *= (double)work);
                }
                double a = (s21 * (s20 * s00 - s10 * s10) - s11 * (s30 * s00 - s10 * s20) + s01 * (s30 * s10 - s20 * s20)) / (s40 * (s20 * s00 - s10 * s10) - s30 * (s30 * s00 - s10 * s20) + s20 * (s30 * s10 - s20 * s20));
                double b = (s40 * (s11 * s00 - s01 * s10) - s30 * (s21 * s00 - s01 * s20) + s20 * (s21 * s10 - s11 * s20)) / (s40 * (s20 * s00 - s10 * s10) - s30 * (s30 * s00 - s10 * s20) + s20 * (s30 * s10 - s20 * s20));
                double c = (s40 * (s20 * s01 - s10 * s11) - s30 * (s30 * s01 - s10 * s21) + s20 * (s30 * s11 - s20 * s21)) / (s40 * (s20 * s00 - s10 * s10) - s30 * (s30 * s00 - s10 * s20) + s20 * (s30 * s10 - s20 * s20));
                double x = totalWork;
                return (long)(a * x * x + b * x + c) - timeMsLog.getLast();
            }
        };


        public abstract long getEtaMs(Deque<Long> var1, Deque<Long> var2, long var3);
    }
}

