/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.tools;

import edu.duke.cs.osprey.tools.RotationMatrix;
import edu.duke.cs.osprey.tools.VectorAlgebra;

public class RigidBodyMotion {
    double[] center1;
    RotationMatrix rotation;
    double[] center2;

    public RigidBodyMotion(double[] center1, RotationMatrix rotation, double[] center2) {
        this.center1 = center1;
        this.rotation = rotation;
        this.center2 = center2;
    }

    public RigidBodyMotion(double[] center, double[] axis, double angle, boolean angleInRadians) {
        this.center1 = center;
        this.center2 = center;
        this.rotation = new RotationMatrix(axis[0], axis[1], axis[2], angle, angleInRadians);
    }

    public RigidBodyMotion(double[] center, double[] axis, double sinAngle, double cosAngle) {
        this.center1 = center;
        this.center2 = center;
        this.rotation = new RotationMatrix(axis[0], axis[1], axis[2], sinAngle, cosAngle);
    }

    public RigidBodyMotion(double[][] initCoords, double[][] finalCoords) {
        this.center1 = (double[])initCoords[0].clone();
        this.center2 = (double[])finalCoords[0].clone();
        double[] uold = VectorAlgebra.subtract(initCoords[1], initCoords[0]);
        double[] unew = VectorAlgebra.subtract(finalCoords[1], finalCoords[0]);
        double[] vold = VectorAlgebra.subtract(initCoords[2], initCoords[0]);
        double[] vnew = VectorAlgebra.subtract(finalCoords[2], finalCoords[0]);
        this.rotation = RotationMatrix.getSuperposingRotMatrix(uold, unew, vold, vnew);
    }

    public void transform(double[] concatCoords) {
        int numVectors = concatCoords.length / 3;
        for (int v = 0; v < numVectors; ++v) {
            this.transform(concatCoords, v);
        }
    }

    public void transform(double[] concatCoords, int index) {
        int a;
        for (a = 0; a < 3; ++a) {
            int n = 3 * index + a;
            concatCoords[n] = concatCoords[n] - this.center1[a];
        }
        this.rotation.applyRotation(concatCoords, index);
        for (a = 0; a < 3; ++a) {
            int n = 3 * index + a;
            concatCoords[n] = concatCoords[n] + this.center2[a];
        }
    }
}

