/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.tools;

import edu.duke.cs.osprey.tools.Protractor;
import edu.duke.cs.osprey.tools.VectorAlgebra;
import java.io.Serializable;

public class RotationMatrix
implements Serializable {
    private static final long serialVersionUID = 2915420374293280379L;
    double[][] matrix;

    public RotationMatrix(double[][] mtx) {
        this.matrix = mtx;
    }

    public RotationMatrix(double fx, double fy, double fz, double angle, boolean angleInRadians) {
        this(fx, fy, fz, angleInRadians ? Math.sin(angle) : Math.sin(Math.toRadians(angle)), angleInRadians ? Math.cos(angle) : Math.cos(Math.toRadians(angle)));
    }

    public RotationMatrix(double fx, double fy, double fz, double sin, double cos) {
        double len = Math.sqrt(fx * fx + fy * fy + fz * fz);
        double ux = fx / len;
        double uy = fy / len;
        double uz = fz / len;
        double omcos = 1.0 - cos;
        double uxyomcos = ux * uy * omcos;
        double uxzomcos = ux * uz * omcos;
        double uyzomcos = uy * uz * omcos;
        double uxsin = ux * sin;
        double uysin = uy * sin;
        double uzsin = uz * sin;
        this.matrix = new double[3][3];
        this.matrix[0][0] = cos + ux * ux * omcos;
        this.matrix[0][1] = uxyomcos - uzsin;
        this.matrix[0][2] = uxzomcos + uysin;
        this.matrix[1][0] = uxyomcos + uzsin;
        this.matrix[1][1] = cos + uy * uy * omcos;
        this.matrix[1][2] = uyzomcos - uxsin;
        this.matrix[2][0] = uxzomcos - uysin;
        this.matrix[2][1] = uyzomcos + uxsin;
        this.matrix[2][2] = cos + uz * uz * omcos;
    }

    public RotationMatrix multiply(RotationMatrix rotation2) {
        return new RotationMatrix(RotationMatrix.multiplyMatrices(this.matrix, rotation2.matrix));
    }

    private static double[][] multiplyMatrices(double[][] M1, double[][] M2) {
        double[][] ans = new double[3][3];
        for (int a = 0; a < 3; ++a) {
            for (int b = 0; b < 3; ++b) {
                ans[a][b] = 0.0;
                for (int c = 0; c < 3; ++c) {
                    double[] dArray = ans[a];
                    int n = b;
                    dArray[n] = dArray[n] + M1[a][c] * M2[c][b];
                }
            }
        }
        return ans;
    }

    public RotationMatrix transpose() {
        double[][] ans = new double[3][3];
        for (int a = 0; a < 3; ++a) {
            for (int b = 0; b < 3; ++b) {
                ans[a][b] = this.matrix[b][a];
            }
        }
        return new RotationMatrix(ans);
    }

    public void applyRotation(double[] x, int index) {
        double[] ans = new double[3];
        for (int a = 0; a < 3; ++a) {
            double val = 0.0;
            for (int b = 0; b < 3; ++b) {
                val += this.matrix[a][b] * x[3 * index + b];
            }
            ans[a] = val;
        }
        System.arraycopy(ans, 0, x, 3 * index, 3);
    }

    public double[] rotateVector(double[] vec) {
        double[] ans = new double[3];
        for (int a = 0; a < 3; ++a) {
            double val = 0.0;
            for (int b = 0; b < 3; ++b) {
                val += this.matrix[a][b] * vec[b];
            }
            ans[a] = val;
        }
        return ans;
    }

    public double[] unrotateVector(double[] vec) {
        double[] ans = new double[3];
        for (int a = 0; a < 3; ++a) {
            double val = 0.0;
            for (int b = 0; b < 3; ++b) {
                val += this.matrix[b][a] * vec[b];
            }
            ans[a] = val;
        }
        return ans;
    }

    public static RotationMatrix identity() {
        double[][] M = new double[3][3];
        for (int a = 0; a < 3; ++a) {
            for (int b = 0; b < 3; ++b) {
                M[a][b] = a == b ? 1.0 : 0.0;
            }
        }
        return new RotationMatrix(M);
    }

    public static RotationMatrix getSuperposingRotMatrix(double[] uold, double[] unew, double[] vold, double[] vnew) {
        double th;
        RotationMatrix mtx1;
        double[] axis1 = VectorAlgebra.cross(uold, unew);
        if (VectorAlgebra.norm(axis1) == 0.0) {
            if (VectorAlgebra.dot(uold, unew) > 0.0) {
                mtx1 = RotationMatrix.identity();
            } else {
                double[] normal = VectorAlgebra.getPerpendicular(uold);
                mtx1 = new RotationMatrix(normal[0], normal[1], normal[2], 180.0, false);
            }
        } else {
            th = Protractor.getAngleRadians(uold, unew);
            mtx1 = new RotationMatrix(axis1[0], axis1[1], axis1[2], th, true);
        }
        double[] w1 = VectorAlgebra.perpendicularComponent(mtx1.rotateVector(vold), unew);
        double[] w2 = VectorAlgebra.perpendicularComponent(vnew, unew);
        th = Protractor.getAngleRadians(w1, w2);
        RotationMatrix mtx2 = VectorAlgebra.dot(VectorAlgebra.cross(w1, w2), unew) > 0.0 ? new RotationMatrix(unew[0], unew[1], unew[2], th, true) : new RotationMatrix(unew[0], unew[1], unew[2], -th, true);
        return mtx2.multiply(mtx1);
    }

    public RotationMatrix copy() {
        double[][] mtx = new double[this.matrix.length][];
        for (int a = 0; a < this.matrix.length; ++a) {
            mtx[a] = (double[])this.matrix[a].clone();
        }
        return new RotationMatrix(mtx);
    }
}

