/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.tools;

import edu.duke.cs.osprey.tools.Streams;
import edu.duke.cs.osprey.tools.TomlParseException;
import org.tomlj.Toml;
import org.tomlj.TomlArray;
import org.tomlj.TomlParseResult;
import org.tomlj.TomlPosition;
import org.tomlj.TomlTable;

public class TomlTools {
    public static TomlTable parseOrThrow(String toml) {
        TomlParseResult doc = Toml.parse((String)toml);
        if (doc.hasErrors()) {
            throw new TomlParseException("TOML parsing failure:\n" + Streams.joinToString(doc.errors(), "\n", err -> err.toString()));
        }
        return doc;
    }

    private static String formatPos(TomlPosition pos) {
        if (pos != null) {
            return String.format(" @ %s", pos);
        }
        return "";
    }

    private static Integer longToIntOrNull(Long longval) {
        int intval = longval.intValue();
        if ((long)intval != longval) {
            return null;
        }
        return intval;
    }

    public static Object getOrThrow(TomlTable table, String key) {
        return TomlTools.getOrThrow(table, key, null);
    }

    public static Object getOrThrow(TomlTable table, String key, TomlPosition tablePos) {
        Object value2 = table.get(key);
        if (value2 == null) {
            throw new TomlParseException(String.format("missing %s in table%s", key, TomlTools.formatPos(tablePos)));
        }
        return value2;
    }

    private static TomlParseException invalidTableType(String key, String desiredType, Object value2, TomlPosition tablePos) {
        return new TomlParseException(String.format("%s in table%s should be a %s, not a(n) %s", key, TomlTools.formatPos(tablePos), desiredType, value2.getClass().getSimpleName()));
    }

    public static TomlTable getTableOrThrow(TomlTable table, String key) {
        return TomlTools.getTableOrThrow(table, key, null);
    }

    public static TomlTable getTableOrThrow(TomlTable table, String key, TomlPosition tablePos) {
        Object value2 = TomlTools.getOrThrow(table, key, tablePos);
        if (value2 instanceof TomlTable) {
            return (TomlTable)value2;
        }
        throw TomlTools.invalidTableType(key, "Table", value2, tablePos);
    }

    public static TomlArray getArrayOrThrow(TomlTable table, String key) {
        return TomlTools.getArrayOrThrow(table, key, null);
    }

    public static TomlArray getArrayOrThrow(TomlTable table, String key, TomlPosition tablePos) {
        Object value2 = TomlTools.getOrThrow(table, key, tablePos);
        if (value2 instanceof TomlArray) {
            return (TomlArray)value2;
        }
        throw TomlTools.invalidTableType(key, "Array", value2, tablePos);
    }

    public static String getStringOrThrow(TomlTable table, String key) {
        return TomlTools.getStringOrThrow(table, key, null);
    }

    public static String getStringOrThrow(TomlTable table, String key, TomlPosition tablePos) {
        Object value2 = TomlTools.getOrThrow(table, key, tablePos);
        if (value2 instanceof String) {
            return (String)value2;
        }
        throw TomlTools.invalidTableType(key, "String", value2, tablePos);
    }

    public static long getLongOrThrow(TomlTable table, String key) {
        return TomlTools.getLongOrThrow(table, key, null);
    }

    public static long getLongOrThrow(TomlTable table, String key, TomlPosition tablePos) {
        Object value2 = TomlTools.getOrThrow(table, key, tablePos);
        if (value2 instanceof Long) {
            return (Long)value2;
        }
        throw TomlTools.invalidTableType(key, "Long", value2, tablePos);
    }

    public static int getIntOrThrow(TomlTable table, String key) {
        return TomlTools.getIntOrThrow(table, key, null);
    }

    public static int getIntOrThrow(TomlTable table, String key, TomlPosition tablePos) {
        Object value2 = TomlTools.getOrThrow(table, key, tablePos);
        if (value2 instanceof Long) {
            Integer intval = TomlTools.longToIntOrNull((Long)value2);
            if (intval == null) {
                throw new TomlParseException(String.format("%s = %d in table%s overflows int value", key, value2, tablePos));
            }
            return intval;
        }
        throw TomlTools.invalidTableType(key, "Int", value2, tablePos);
    }

    public static double getDoubleOrThrow(TomlTable table, String key) {
        return TomlTools.getDoubleOrThrow(table, key, null);
    }

    public static double getDoubleOrThrow(TomlTable table, String key, TomlPosition tablePos) {
        Object value2 = TomlTools.getOrThrow(table, key, tablePos);
        if (value2 instanceof Double) {
            return (Double)value2;
        }
        throw TomlTools.invalidTableType(key, "Double", value2, tablePos);
    }

    public static boolean getBooleanOrThrow(TomlTable table, String key) {
        return TomlTools.getBooleanOrThrow(table, key, null);
    }

    public static boolean getBooleanOrThrow(TomlTable table, String key, TomlPosition tablePos) {
        Object value2 = TomlTools.getOrThrow(table, key, tablePos);
        if (value2 instanceof Boolean) {
            return (Boolean)value2;
        }
        throw TomlTools.invalidTableType(key, "Boolean", value2, tablePos);
    }

    public static Object getOrThrow(TomlArray array, int i) {
        return TomlTools.getOrThrow(array, i, null);
    }

    public static Object getOrThrow(TomlArray array, int i, TomlPosition tablePos) {
        Object value2 = null;
        if (i >= 0 && i < array.size()) {
            value2 = array.get(i);
        }
        if (value2 == null) {
            throw new TomlParseException(String.format("missing index %d in array%s", i, TomlTools.formatPos(tablePos)));
        }
        return value2;
    }

    private static TomlParseException invalidArrayType(int i, String desiredType, Object value2, TomlPosition iPos) {
        return new TomlParseException(String.format("index %d%s in array should be a %s, not a(n) %s", i, TomlTools.formatPos(iPos), desiredType, value2.getClass().getSimpleName()));
    }

    public static TomlTable getTableOrThrow(TomlArray array, int i) {
        return TomlTools.getTableOrThrow(array, i, null);
    }

    public static TomlTable getTableOrThrow(TomlArray array, int i, TomlPosition arrayPos) {
        Object value2 = TomlTools.getOrThrow(array, i, arrayPos);
        if (value2 instanceof TomlTable) {
            return (TomlTable)value2;
        }
        throw TomlTools.invalidArrayType(i, "Table", value2, array.inputPositionOf(i));
    }

    public static TomlArray getArrayOrThrow(TomlArray array, int i) {
        return TomlTools.getArrayOrThrow(array, i, null);
    }

    public static TomlArray getArrayOrThrow(TomlArray array, int i, TomlPosition arrayPos) {
        Object value2 = TomlTools.getOrThrow(array, i, arrayPos);
        if (value2 instanceof TomlArray) {
            return (TomlArray)value2;
        }
        throw TomlTools.invalidArrayType(i, "Array", value2, array.inputPositionOf(i));
    }

    public static String getStringOrThrow(TomlArray array, int i) {
        return TomlTools.getStringOrThrow(array, i, null);
    }

    public static String getStringOrThrow(TomlArray array, int i, TomlPosition arrayPos) {
        Object value2 = TomlTools.getOrThrow(array, i, arrayPos);
        if (value2 instanceof String) {
            return (String)value2;
        }
        throw TomlTools.invalidArrayType(i, "String", value2, array.inputPositionOf(i));
    }

    public static long getLongOrThrow(TomlArray array, int i) {
        return TomlTools.getLongOrThrow(array, i, null);
    }

    public static long getLongOrThrow(TomlArray array, int i, TomlPosition arrayPos) {
        Object value2 = TomlTools.getOrThrow(array, i, arrayPos);
        if (value2 instanceof Long) {
            return (Long)value2;
        }
        throw TomlTools.invalidArrayType(i, "Long", value2, array.inputPositionOf(i));
    }

    public static int getIntOrThrow(TomlArray array, int i) {
        return TomlTools.getIntOrThrow(array, i, null);
    }

    public static int getIntOrThrow(TomlArray array, int i, TomlPosition arrayPos) {
        Object value2 = TomlTools.getOrThrow(array, i, arrayPos);
        if (value2 instanceof Long) {
            Integer intval = TomlTools.longToIntOrNull((Long)value2);
            if (intval == null) {
                throw new TomlParseException(String.format("index %d%s in array = %d overflows int value", i, TomlTools.formatPos(array.inputPositionOf(i)), value2));
            }
            return intval;
        }
        throw TomlTools.invalidArrayType(i, "Int", value2, array.inputPositionOf(i));
    }

    public static double getDoubleOrThrow(TomlArray array, int i) {
        return TomlTools.getDoubleOrThrow(array, i, null);
    }

    public static double getDoubleOrThrow(TomlArray array, int i, TomlPosition arrayPos) {
        Object value2 = TomlTools.getOrThrow(array, i, arrayPos);
        if (value2 instanceof Double) {
            return (Double)value2;
        }
        throw TomlTools.invalidArrayType(i, "Double", value2, array.inputPositionOf(i));
    }

    public static boolean getBooleanOrThrow(TomlArray array, int i) {
        return TomlTools.getBooleanOrThrow(array, i, null);
    }

    public static boolean getBooleanOrThrow(TomlArray array, int i, TomlPosition arrayPos) {
        Object value2 = TomlTools.getOrThrow(array, i, arrayPos);
        if (value2 instanceof Boolean) {
            return (Boolean)value2;
        }
        throw TomlTools.invalidArrayType(i, "Boolean", value2, array.inputPositionOf(i));
    }
}

