/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.tupexp;

import edu.duke.cs.osprey.tupexp.CGTupleFitter;
import edu.duke.cs.osprey.tupexp.TupleIndexMatrix;
import java.util.ArrayList;

class FittingObjFcn {
    double thresh = Double.POSITIVE_INFINITY;
    double k;
    WeightingMode wtMode = WeightingMode.REGULAR;

    FittingObjFcn() {
    }

    FittingObjFcn(double thresh, double k, boolean useRelWt, boolean useThreshWt) {
        this.thresh = thresh;
        this.k = k;
        this.wtMode = useThreshWt ? WeightingMode.THRESHWT : (useRelWt ? WeightingMode.ONEWT : WeightingMode.REGULAR);
        if (k < 0.0 || k > 1.0) {
            throw new RuntimeException("ERROR: Invalid modified least squares k value");
        }
    }

    double computeResid(double fitVal, double trueVal) {
        double penalizedError = fitVal - trueVal;
        return penalizedError * penalizedError;
    }

    CGTupleFitter makeTupleFitter(TupleIndexMatrix tim, ArrayList<int[]> samp, int numTuples, double[] trueVals) {
        ArrayList<Double> tv = new ArrayList<Double>();
        for (double tvv : trueVals) {
            tv.add(tvv);
        }
        ArrayList<Double> weights = this.computeWeights(tv, 0.0);
        return new CGTupleFitter(tim, samp, numTuples, trueVals, weights);
    }

    double unnormalizedWeight(double trueVal) {
        double relCutoff = 1.0;
        switch (this.wtMode) {
            case REGULAR: {
                return 1.0;
            }
            case THRESHWT: {
                relCutoff = this.thresh;
            }
        }
        if (trueVal < relCutoff) {
            return 1.0;
        }
        double x = relCutoff / trueVal;
        return x * x;
    }

    ArrayList<Double> computeWeights(ArrayList<Double> offsetTrueVals, double energyOffset) {
        int s;
        int numSamp = offsetTrueVals.size();
        ArrayList<Double> weights = new ArrayList<Double>();
        double wtsum = 0.0;
        for (s = 0; s < numSamp; ++s) {
            double targetVal = offsetTrueVals.get(s) - energyOffset;
            double unnormWt = this.unnormalizedWeight(targetVal);
            weights.add(unnormWt);
            wtsum += unnormWt;
        }
        for (s = 0; s < numSamp; ++s) {
            weights.set(s, weights.get(s) * ((double)numSamp / wtsum));
        }
        return weights;
    }

    ArrayList<Double> computeAllResids(ArrayList<Double> offsetTrueVals, ArrayList<Double> offsetFitVals, double energyOffset) {
        ArrayList<Double> weights = this.computeWeights(offsetTrueVals, energyOffset);
        ArrayList<Double> sampleResids = new ArrayList<Double>();
        int numSamp = weights.size();
        for (int s = 0; s < numSamp; ++s) {
            double targetVal = offsetTrueVals.get(s) - energyOffset;
            double sampResid = this.computeResid(offsetFitVals.get(s) - energyOffset, targetVal);
            sampleResids.add(weights.get(s) * sampResid);
        }
        return sampleResids;
    }

    static enum WeightingMode {
        REGULAR,
        ONEWT,
        THRESHWT;

    }
}

