@rem
@rem Copyright 2015 the original author or authors.
@rem
@rem Licensed under the Apache License, Version 2.0 (the "License");
@rem you may not use this file except in compliance with the License.
@rem You may obtain a copy of the License at
@rem
@rem      https://www.apache.org/licenses/LICENSE-2.0
@rem
@rem Unless required by applicable law or agreed to in writing, software
@rem distributed under the License is distributed on an "AS IS" BASIS,
@rem WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
@rem See the License for the specific language governing permissions and
@rem limitations under the License.
@rem

@if "%DEBUG%"=="" @echo off
@rem ##########################################################################
@rem
@rem  osprey3 startup script for Windows
@rem
@rem ##########################################################################

@rem Set local scope for the variables with windows NT shell
if "%OS%"=="Windows_NT" setlocal

set DIRNAME=%~dp0
if "%DIRNAME%"=="" set DIRNAME=.
@rem This is normally unused
set APP_BASE_NAME=%~n0
set APP_HOME=%DIRNAME%..

@rem Resolve any "." and ".." in APP_HOME to make it shorter.
for %%i in ("%APP_HOME%") do set APP_HOME=%%~fi

@rem Add default JVM options here. You can also use JAVA_OPTS and OSPREY3_OPTS to pass JVM options to this script.
set DEFAULT_JVM_OPTS=

@rem Find java.exe
if defined JAVA_HOME goto findJavaFromJavaHome

set JAVA_EXE=java.exe
%JAVA_EXE% -version >NUL 2>&1
if %ERRORLEVEL% equ 0 goto execute

echo.
echo ERROR: JAVA_HOME is not set and no 'java' command could be found in your PATH.
echo.
echo Please set the JAVA_HOME variable in your environment to match the
echo location of your Java installation.

goto fail

:findJavaFromJavaHome
set JAVA_HOME=%JAVA_HOME:"=%
set JAVA_EXE=%JAVA_HOME%/bin/java.exe

if exist "%JAVA_EXE%" goto execute

echo.
echo ERROR: JAVA_HOME is set to an invalid directory: %JAVA_HOME%
echo.
echo Please set the JAVA_HOME variable in your environment to match the
echo location of your Java installation.

goto fail

:execute
@rem Setup the command line

set CLASSPATH=%APP_HOME%\lib\osprey3-3.3.jar;%APP_HOME%\lib\kdtree.jar;%APP_HOME%\lib\javafx-controls-11-linux.jar;%APP_HOME%\lib\javafx-graphics-11-linux.jar;%APP_HOME%\lib\javafx-graphics-11.jar;%APP_HOME%\lib\javafx-base-11-linux.jar;%APP_HOME%\lib\javafx-base-11.jar;%APP_HOME%\lib\kludge-0.2.jar;%APP_HOME%\lib\ktor-client-apache-jvm-1.6.8.jar;%APP_HOME%\lib\ktor-server-netty-jvm-1.6.8.jar;%APP_HOME%\lib\ktor-serialization-jvm-1.6.8.jar;%APP_HOME%\lib\ktor-server-host-common-jvm-1.6.8.jar;%APP_HOME%\lib\ktor-server-core-jvm-1.6.8.jar;%APP_HOME%\lib\kotlinx-coroutines-jdk8-1.5.2-native-mt.jar;%APP_HOME%\lib\ktor-client-serialization-jvm-1.6.8.jar;%APP_HOME%\lib\ktor-client-json-jvm-1.6.8.jar;%APP_HOME%\lib\ktor-client-core-jvm-1.6.8.jar;%APP_HOME%\lib\ktor-http-cio-jvm-1.6.8.jar;%APP_HOME%\lib\ktor-http-jvm-1.6.8.jar;%APP_HOME%\lib\ktor-network-jvm-1.6.8.jar;%APP_HOME%\lib\ktor-utils-jvm-1.6.8.jar;%APP_HOME%\lib\ktor-io-jvm-1.6.8.jar;%APP_HOME%\lib\kotlinx-coroutines-core-jvm-1.5.2-native-mt.jar;%APP_HOME%\lib\kotlin-stdlib-jdk8-1.8.21.jar;%APP_HOME%\lib\kotlin-reflect-1.8.21.jar;%APP_HOME%\lib\logback-classic-1.2.3.jar;%APP_HOME%\lib\jul-to-slf4j-1.7.30.jar;%APP_HOME%\lib\joptimizer-3.5.1.jar;%APP_HOME%\lib\colt-1.2.0.jar;%APP_HOME%\lib\commons-collections4-4.1.jar;%APP_HOME%\lib\gluegen-rt-2.3.2.jar;%APP_HOME%\lib\gluegen-rt-2.3.2-natives-linux-amd64.jar;%APP_HOME%\lib\gluegen-rt-2.3.2-natives-macosx-universal.jar;%APP_HOME%\lib\gluegen-rt-2.3.2-natives-windows-amd64.jar;%APP_HOME%\lib\jocl-2.3.2.jar;%APP_HOME%\lib\jocl-2.3.2-natives-linux-amd64.jar;%APP_HOME%\lib\jocl-2.3.2-natives-macosx-universal.jar;%APP_HOME%\lib\jocl-2.3.2-natives-windows-amd64.jar;%APP_HOME%\lib\mapdb-3.0.5.jar;%APP_HOME%\lib\batik-svggen-1.9.1.jar;%APP_HOME%\lib\batik-svg-dom-1.9.1.jar;%APP_HOME%\lib\smile-core-1.5.1.jar;%APP_HOME%\lib\smile-netlib-1.5.1.jar;%APP_HOME%\lib\elki-0.7.1.jar;%APP_HOME%\lib\big-math-2.3.0.jar;%APP_HOME%\lib\joml-1.9.19.jar;%APP_HOME%\lib\xz-1.8.jar;%APP_HOME%\lib\jna-5.10.0.jar;%APP_HOME%\lib\batik-parser-1.9.1.jar;%APP_HOME%\lib\batik-awt-util-1.9.1.jar;%APP_HOME%\lib\batik-dom-1.9.1.jar;%APP_HOME%\lib\batik-css-1.9.1.jar;%APP_HOME%\lib\xmlgraphics-commons-2.2.jar;%APP_HOME%\lib\commons-io-2.5.jar;%APP_HOME%\lib\tomlj-1.0.0.jar;%APP_HOME%\lib\jackson-databind-2.9.9.jar;%APP_HOME%\lib\jackson-dataformat-yaml-2.9.9.jar;%APP_HOME%\lib\jcommander-1.72.jar;%APP_HOME%\lib\streamex-0.8.0.jar;%APP_HOME%\lib\jcuda-0.8.0.jar;%APP_HOME%\lib\jcuda-natives-0.8.0-linux-x86_64.jar;%APP_HOME%\lib\jcuda-natives-0.8.0-apple-x86_64.jar;%APP_HOME%\lib\jcuda-natives-0.8.0-windows-x86_64.jar;%APP_HOME%\lib\kotlin-stdlib-jdk7-1.8.21.jar;%APP_HOME%\lib\kotlinx-serialization-json-jvm-1.3.0.jar;%APP_HOME%\lib\kotlinx-serialization-core-jvm-1.3.0.jar;%APP_HOME%\lib\kotlin-stdlib-1.8.21.jar;%APP_HOME%\lib\logback-core-1.2.3.jar;%APP_HOME%\lib\smile-data-1.5.1.jar;%APP_HOME%\lib\smile-graph-1.5.1.jar;%APP_HOME%\lib\smile-math-1.5.1.jar;%APP_HOME%\lib\slf4j-api-1.7.36.jar;%APP_HOME%\lib\concurrent-1.3.4.jar;%APP_HOME%\lib\httpasyncclient-4.1.5.jar;%APP_HOME%\lib\httpclient-4.5.13.jar;%APP_HOME%\lib\commons-logging-1.2.jar;%APP_HOME%\lib\log4j-1.2.14.jar;%APP_HOME%\lib\csparsej-1.1.1.jar;%APP_HOME%\lib\commons-lang3-3.4.jar;%APP_HOME%\lib\commons-math3-3.6.1.jar;%APP_HOME%\lib\commons-csv-1.3.jar;%APP_HOME%\lib\eclipse-collections-forkjoin-7.1.2.jar;%APP_HOME%\lib\eclipse-collections-7.1.2.jar;%APP_HOME%\lib\eclipse-collections-api-7.1.2.jar;%APP_HOME%\lib\guava-19.0.jar;%APP_HOME%\lib\lz4-1.3.0.jar;%APP_HOME%\lib\elsa-3.0.0-M5.jar;%APP_HOME%\lib\batik-xml-1.9.1.jar;%APP_HOME%\lib\batik-util-1.9.1.jar;%APP_HOME%\lib\batik-ext-1.9.1.jar;%APP_HOME%\lib\xml-apis-ext-1.3.04.jar;%APP_HOME%\lib\all-1.1.2.pom;%APP_HOME%\lib\netlib-native_ref-osx-x86_64-1.1-natives.jar;%APP_HOME%\lib\netlib-native_ref-linux-x86_64-1.1-natives.jar;%APP_HOME%\lib\netlib-native_ref-linux-i686-1.1-natives.jar;%APP_HOME%\lib\netlib-native_ref-win-x86_64-1.1-natives.jar;%APP_HOME%\lib\netlib-native_ref-win-i686-1.1-natives.jar;%APP_HOME%\lib\netlib-native_ref-linux-armhf-1.1-natives.jar;%APP_HOME%\lib\native_ref-java-1.1.jar;%APP_HOME%\lib\netlib-native_system-osx-x86_64-1.1-natives.jar;%APP_HOME%\lib\netlib-native_system-linux-x86_64-1.1-natives.jar;%APP_HOME%\lib\netlib-native_system-linux-i686-1.1-natives.jar;%APP_HOME%\lib\netlib-native_system-linux-armhf-1.1-natives.jar;%APP_HOME%\lib\netlib-native_system-win-x86_64-1.1-natives.jar;%APP_HOME%\lib\netlib-native_system-win-i686-1.1-natives.jar;%APP_HOME%\lib\native_system-java-1.1.jar;%APP_HOME%\lib\core-1.1.2.jar;%APP_HOME%\lib\arpack_combined_all-0.1.jar;%APP_HOME%\lib\trove4j-3.0.3.jar;%APP_HOME%\lib\antlr4-runtime-4.7.2.jar;%APP_HOME%\lib\jsr305-3.0.2.jar;%APP_HOME%\lib\jackson-annotations-2.9.0.jar;%APP_HOME%\lib\jackson-core-2.9.9.jar;%APP_HOME%\lib\snakeyaml-1.23.jar;%APP_HOME%\lib\lwjgl-glfw-3.2.2.jar;%APP_HOME%\lib\lwjgl-glfw-3.2.2-natives-linux.jar;%APP_HOME%\lib\lwjgl-glfw-3.2.2-natives-macos.jar;%APP_HOME%\lib\lwjgl-glfw-3.2.2-natives-windows.jar;%APP_HOME%\lib\lwjgl-jemalloc-3.2.2.jar;%APP_HOME%\lib\lwjgl-jemalloc-3.2.2-natives-linux.jar;%APP_HOME%\lib\lwjgl-jemalloc-3.2.2-natives-macos.jar;%APP_HOME%\lib\lwjgl-jemalloc-3.2.2-natives-windows.jar;%APP_HOME%\lib\lwjgl-nfd-3.2.2.jar;%APP_HOME%\lib\lwjgl-nfd-3.2.2-natives-linux.jar;%APP_HOME%\lib\lwjgl-nfd-3.2.2-natives-macos.jar;%APP_HOME%\lib\lwjgl-nfd-3.2.2-natives-windows.jar;%APP_HOME%\lib\lwjgl-vulkan-3.2.2.jar;%APP_HOME%\lib\lwjgl-vulkan-3.2.2-natives-macos.jar;%APP_HOME%\lib\lwjgl-3.2.2.jar;%APP_HOME%\lib\lwjgl-3.2.2-natives-linux.jar;%APP_HOME%\lib\lwjgl-3.2.2-natives-macos.jar;%APP_HOME%\lib\lwjgl-3.2.2-natives-windows.jar;%APP_HOME%\lib\kotlin-stdlib-common-1.8.21.jar;%APP_HOME%\lib\netty-codec-http2-4.1.74.Final.jar;%APP_HOME%\lib\alpn-api-1.1.3.v20160715.jar;%APP_HOME%\lib\netty-transport-native-kqueue-4.1.74.Final.jar;%APP_HOME%\lib\netty-transport-native-epoll-4.1.74.Final.jar;%APP_HOME%\lib\annotations-13.0.jar;%APP_HOME%\lib\jcip-annotations-1.0.jar;%APP_HOME%\lib\batik-constants-1.9.1.jar;%APP_HOME%\lib\batik-i18n-1.9.1.jar;%APP_HOME%\lib\xalan-2.7.2.jar;%APP_HOME%\lib\serializer-2.7.2.jar;%APP_HOME%\lib\xml-apis-1.3.04.jar;%APP_HOME%\lib\httpcore-nio-4.4.15.jar;%APP_HOME%\lib\httpcore-4.4.15.jar;%APP_HOME%\lib\netty-codec-http-4.1.74.Final.jar;%APP_HOME%\lib\netty-handler-4.1.74.Final.jar;%APP_HOME%\lib\netty-codec-4.1.74.Final.jar;%APP_HOME%\lib\netty-transport-classes-kqueue-4.1.74.Final.jar;%APP_HOME%\lib\netty-transport-classes-epoll-4.1.74.Final.jar;%APP_HOME%\lib\netty-transport-native-unix-common-4.1.74.Final.jar;%APP_HOME%\lib\netty-transport-4.1.74.Final.jar;%APP_HOME%\lib\netty-buffer-4.1.74.Final.jar;%APP_HOME%\lib\netty-resolver-4.1.74.Final.jar;%APP_HOME%\lib\netty-common-4.1.74.Final.jar;%APP_HOME%\lib\commons-codec-1.11.jar;%APP_HOME%\lib\netty-tcnative-classes-2.0.48.Final.jar;%APP_HOME%\lib\config-1.4.1.jar;%APP_HOME%\lib\jansi-2.4.0.jar;%APP_HOME%\lib\jniloader-1.1.jar


@rem Execute osprey3
"%JAVA_EXE%" %DEFAULT_JVM_OPTS% %JAVA_OPTS% %OSPREY3_OPTS%  -classpath "%CLASSPATH%" edu.duke.cs.osprey.design.Main %*

:end
@rem End local scope for the variables with windows NT shell
if %ERRORLEVEL% equ 0 goto mainEnd

:fail
rem Set variable OSPREY3_EXIT_CONSOLE if you need the _script_ return code instead of
rem the _cmd.exe /c_ return code!
set EXIT_CODE=%ERRORLEVEL%
if %EXIT_CODE% equ 0 set EXIT_CODE=1
if not ""=="%OSPREY3_EXIT_CONSOLE%" exit %EXIT_CODE%
exit /b %EXIT_CODE%

:mainEnd
if "%OS%"=="Windows_NT" endlocal

:omega
