module TranslationTables

using BioSequences

export CodonTable, AA1_3, AA3_1

CodonTable = Dict{DNACodon, AminoAcid}(
	DNACodon("ATT") => AA_I, 
	DNACodon("ATC") => AA_I, 
	DNACodon("ATA") => AA_I,
	DNACodon("CTT") => AA_L,
	DNACodon("CTC") => AA_L,
	DNACodon("CTA") => AA_L,
	DNACodon("CTG") => AA_L,
	DNACodon("TTA") => AA_L,
	DNACodon("TTG") => AA_L,
	DNACodon("GTT") => AA_V,
	DNACodon("GTC") => AA_V,
	DNACodon("GTA") => AA_V,
	DNACodon("GTG") => AA_V,
	DNACodon("TTT") => AA_F,
	DNACodon("TTC") => AA_F,
	DNACodon("ATG") => AA_M,
	DNACodon("TGT") => AA_C,
	DNACodon("TGC") => AA_C,
	DNACodon("GCT") => AA_A,
	DNACodon("GCC") => AA_A,
	DNACodon("GCA") => AA_A,
	DNACodon("GCG") => AA_A,
	DNACodon("GGT") => AA_G,
	DNACodon("GGC") => AA_G, 
	DNACodon("GGA") => AA_G,
	DNACodon("GGG") => AA_G,
	DNACodon("CCT") => AA_P,
	DNACodon("CCC") => AA_P,
	DNACodon("CCA") => AA_P,
	DNACodon("CCG") => AA_P,
	DNACodon("ACT") => AA_T,
	DNACodon("ACC") => AA_T,
	DNACodon("ACA") => AA_T,
	DNACodon("ACG") => AA_T,
	DNACodon("TCT") => AA_S,
	DNACodon("TCC") => AA_S,
	DNACodon("TCA") => AA_S, 
	DNACodon("TCG") => AA_S,
	DNACodon("AGT") => AA_S,
	DNACodon("AGC") => AA_S,
	DNACodon("TAT") => AA_Y,
	DNACodon("TAC") => AA_Y,
	DNACodon("TGG") => AA_W,
	DNACodon("CAA") => AA_Q,
	DNACodon("CAG") => AA_Q,
	DNACodon("AAT") => AA_N,
	DNACodon("AAC") => AA_N,
	DNACodon("CAT") => AA_H,
	DNACodon("CAC") => AA_H,
	DNACodon("GAA") => AA_E,
	DNACodon("GAG") => AA_E,
	DNACodon("GAT") => AA_D,
	DNACodon("GAC") => AA_D,
	DNACodon("AAA") => AA_K,
	DNACodon("AAG") => AA_K,
	DNACodon("CGT") => AA_R,
	DNACodon("CGC") => AA_R,
	DNACodon("CGA") => AA_R,
	DNACodon("CGG") => AA_R,
	DNACodon("AGA") => AA_R,
	DNACodon("AGG") => AA_R,
	DNACodon("TAA") => AA_Term,
	DNACodon("TAG") => AA_Term,
	DNACodon("TGA") => AA_Term
)

AA1_3 = Dict{Char, String}(
	'A' => "Ala",
	'R' => "Arg",
    'N' => "Asn",
    'D' => "Asp",
    'C' => "Cys",
    'Q' => "Gln",
    'E' => "Glu",
    'G' => "Gly",
    'H' => "His",
    'I' => "Ile",
    'L' => "Leu",
    'K' => "Lys",
    'M' => "Met",
    'F' => "Phe",
    'P' => "Pro",
    'S' => "Ser",
    'T' => "Thr",
    'W' => "Trp",
    'Y' => "Tyr",
    'V' => "Val"
)

AA3_1 = Dict{String, Char}(
	"Ala" => 'A',
	"Arg" => 'R',
    "Asn" => 'N',
    "Asp" => 'D',
    "Cys" => 'C',
    "Gln" => 'Q',
    "Glu" => 'E',
    "Gly" => 'G',
    "His" => 'H',
    "Hip" => 'H',
    "Hid" => 'H',
    "Hie" => 'H',
    "Ile" => 'I',
    "Leu" => 'L',
    "Lys" => 'K',
    "Met" => 'M',
    "Phe" => 'F',
    "Pro" => 'P',
    "Ser" => 'S',
    "Thr" => 'T',
    "Trp" => 'W',
    "Tyr" => 'Y',
    "Val" => 'V'
)

end
