import java.io.Serializable;

public class BranchTree implements Serializable {

	private TreeNode root = null; //the root of the tree
	
	public BranchTree(){
		
		/*
		 * 
		 * 
		 */
		
		checkTree();
	}
	
	//Traverses the current tree starting at the root
	public void traverseTree(StrandRotamers sysLR, StrandRotamers ligRot, Molecule m, RotamerLibrary rl,
			RotamerLibrary grl, boolean prunedRot[], int numTotalRot, int rotIndOffset[], float eMatrix[][][][][][], InteractionGraph G){
		
		traverseTreeHelper(root, sysLR, ligRot, m, rl, grl, prunedRot, numTotalRot, rotIndOffset, eMatrix, G);
	}

	//Performs post-order traversal of the tree
	private void traverseTreeHelper(TreeNode n, StrandRotamers sysLR, StrandRotamers ligRot, Molecule m, RotamerLibrary rl,
			RotamerLibrary grl, boolean prunedRot[], int numTotalRot, int rotIndOffset[], float eMatrix[][][][][][], InteractionGraph G){
		
		TreeNode lc = n.getlc();
		if (lc!=null) //traverse left subtree first
			traverseTreeHelper(lc, sysLR, ligRot, m, rl, grl, prunedRot, numTotalRot, rotIndOffset, eMatrix, G);
		
		TreeNode rc = n.getrc();
		if (rc!=null) //then traverse right subtree
			traverseTreeHelper(rc, sysLR, ligRot, m, rl, grl, prunedRot, numTotalRot, rotIndOffset, eMatrix, G);
		
		TreeEdge curEdge = n.getCofEdge();
		if (curEdge==null){ //this is the root, so finish computation and output results
			
			TreeEdge rootEdge = n.getlc().getCofEdge(); //the root is a parent of only one node ('s')
			rootEdge.computeA(sysLR, ligRot, m, rl, grl, prunedRot, numTotalRot, rotIndOffset, eMatrix, G);
			
			/*
			 * 
			 * 
			 */
		}
		else if (curEdge.getIsLambdaEdge()){ //lambda edge, so perform the A matrix computation
			curEdge.computeA(sysLR, ligRot, m, rl, grl, prunedRot, numTotalRot, rotIndOffset, eMatrix, G);
			
			/*
			 * 
			 * 
			 */
		}
		
		/*
		 * 
		 * 
		 */
	}
	
	//Checks if all nodes in the tree have either degree 1 (leaves) or degree 3 (internal nodes)
	private void checkTree(){
		
		/*
		 * 
		 */
	}
}
