///////////////////////////////////////////////////////////////////////////////////////////////
//	ParamSet.java
//
//	Version:           0.3
//
//
//	  authors:
// 	  initials    name                 organization                email
//	 ---------   -----------------    ------------------------    ----------------------------
//	  ISG		 Ivelin Georgiev	  Duke University			  ivelin.georgiev@duke.edu
//
///////////////////////////////////////////////////////////////////////////////////////////////

/**
* Written by Ivelin Georgiev (2004-2008)
* 
*/

/*
	This library is free software; you can redistribute it and/or
	modify it under the terms of the GNU Lesser General Public
	License as published by the Free Software Foundation; either
	version 2.1 of the License, or (at your option) any later version.
	This library is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
	Lesser General Public License for more details.
	
	You should have received a copy of the GNU Lesser General Public
	License along with this library; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
	USA
	
	Contact Info:
		Bruce Donald
		Duke University
		Department of Computer Science
		Levine Science Research Center (LSRC)
		Durham
		NC 27708-0129 
		USA
		brd@cs.duke.edu
	
	If you use or publish any results derived from the use of this
	program please cite:
	Georgiev I, Lilien R, Donald B. "Improved Pruning Algorithms and
	Divide-and-Conquer Strategies for Dead-End Elimination, with Application 
	to Protein Design" Bioinformatics, 22(14): e174-e183, 2006.
	
	Copyright (C) 2006 Ivelin Georgiev, Ryan H. Lilien, and Bruce R. Donald
		
	<signature of Bruce Donald>, 23 Aug, 2006
	Bruce Donald, Professor of Computer Science
*/

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.util.StringTokenizer;
import java.io.Serializable;

//Handles the configuration parameter pairs
public class ParamSet implements Serializable {
	
	private String params[] = null; //the parameter names
	private String values[] = null; //the parameter values
	private int curNum = 0; //the number of used positions in the arrays
	
	//constructor
	ParamSet(){
		int initSize = 50; //the initial size of the arrays; increased if necessary
		params = new String[initSize];
		values = new String[initSize];
	}
	
	//Reads in all parameter pairs from the file fName and updates the params[] and values[] arrays
	public void addParamsFromFile(String fName){
		
		BufferedReader bufread = null;
		String curLine = null;
		boolean done = false;
		
		// First attempt to open and read the config file
		try{
			FileInputStream is = new FileInputStream(fName);
			bufread = new BufferedReader(new InputStreamReader(is));

			curLine = bufread.readLine();

			while (curLine != null){
				done = false;
				while (!done) {
					if (curLine.charAt(0) == '%'){
						curLine = bufread.readLine();
					}
					else {
						done = true;
					}
					if (curLine == null)
						done = true;
				}
				if (curLine != null){
					String paramName = getToken(curLine,1);
					int ind = getParamInd(paramName);
					if (ind>=0){ //parameter already read, but only one definition should exist
						System.out.println("ERROR: parameter "+paramName+" already read");
						System.exit(1);
					}
					else { // new parameter
						if (curNum>=params.length){ //double the size of the arrays
							
							String tmp[] = new String[2*params.length];
							System.arraycopy(params, 0, tmp, 0, params.length);
							params = tmp;
							
							tmp = new String[2*values.length];
							System.arraycopy(values,0,tmp,0,values.length);
							values = tmp;
						}
						
						params[curNum] = getToken(curLine,1);
						values[curNum] = curLine.substring(params[curNum].length()+1);
						curNum++;
						curLine = bufread.readLine();
					}
				}
			}
			bufread.close();
		}
		catch(Exception ex)
		{
			System.out.println("ERROR: An error occurred reading configuration file "+fName);
			System.exit(1);
		}
	}
	
	//Returns the index into params[] of the parameter paramName; return -1 if not found
	private int getParamInd(String paramName){
		for (int i=0; i<curNum; i++){
			if (params[i].equalsIgnoreCase(paramName))
				return i;
		}
		return -1;
	}
	
	//Returns the value from values[] that corresponds to the parameter paramName from params[];
	public String getValue(String paramName){
		int ind = getParamInd(paramName);
		if (ind>=0)
			return values[ind];
		else {		
			System.out.println("ERROR: Parameter "+paramName+" not found");
			System.exit(1);
			return null;
		}
	}
	
	//Sets the value of parameter paramName to newValue
	public void setValue(String paramName, String newValue){
		int ind = getParamInd(paramName);
		if (ind>=0)
			values[ind] = newValue;
		else {
			System.out.println("ERROR: Parameter "+paramName+" not found");
			System.exit(1);
		}
	}
	
	public String [] getParams(){
		return params;
	}
	
	public String [] getValues(){
		return values;
	}
	
	public int getCurNum(){
		return curNum;
	}
	
	public void setParamsValues(String inP[], String inV[], int nP){
		curNum = nP;
		params = new String[curNum];
		values = new String[curNum];
		for (int i=0; i<curNum; i++){
			params[i] = inP[i];
			values[i] = inV[i];
		}
	}
	
	// This function returns the xth token in string s
	private String getToken(String s, int x) {
	
		int curNum = 1;	
		StringTokenizer st = new StringTokenizer(s," ,;\t\n\r\f");
		
		while (curNum < x) {
			curNum++;
			if (st.hasMoreTokens())
			  st.nextToken();
			else {
				// System.out.println("ERROR: Unable to access parameter " + x);
				return(new String(""));
			}
		}
		
		if (st.hasMoreTokens())		
			return(st.nextToken());
		return(new String(""));

	} // end getToken
}
