/*
 * This file is part of RDC-ANALYTIC.
 *
 * RDC-ANALYTIC Protein Backbone Structure Determination Software Version 1.0
 * Copyright (C) 2001-2012 Bruce Donald Lab, Duke University
 *
 * RDC-ANALYTIC is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation, either version 3 of the License, or (at your option) any
 * later version.
 *
 * RDC-ANALYTIC is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, see:
 *     <http://www.gnu.org/licenses/>.
 *
 * There are additional restrictions imposed on the use and distribution of this
 * open-source code, including: (A) this header must be included in any
 * modification or extension of the code; (B) you are required to cite our
 * papers in any publications that use this code. The citation for the various
 * different modules of our software, together with a complete list of
 * requirements and restrictions are found in the document license.pdf enclosed
 * with this distribution.
 *
 * Contact Info:
 *     Bruce R. Donald
 *     Duke University
 *     Department of Computer Science
 *     Levine Science Research Center (LSRC)
 *     Durham, NC 27708-0129
 *     USA
 *     email: www.cs.duke.edu/brd/
 *
 * <signature of Bruce Donald>, August 04, 2012
 * Bruce R. Donald, Professor of Computer Science and Biochemistry
 */

/**
 * @version       1.0.1, August 04, 2012
 * @author        Chittaranjan Tripathy (2007-2012)
 * @email         chittu@cs.duke.edu
 * @organization  Duke University
 */

/**
 * Package specification
 */
package analytic;

/**
 * Import statement(s)
 */
import java.io.*;
import java.util.*;
/**
 * Description of the class
 */
/**
 * TODO: Note this class is not being used now. Probably this class will be removed in future.
 * @author Chittu
 */
public class myPdbUtility {
//
//    /**
//     * An atom in the PDB row format.
//     */
//    //ATOM   5212  OG  SER A 337      -0.684  11.846 -11.394  0.50 13.13      5ECD 123
//    //ATOM    212  O   SER D  12     -27.633   4.997  14.478  1.00 22.22      6FAB 132
//    String atom_line_iformat = "ATOM  %5d%*1c%4c%1c%3c%*c%1c%4d%1c%*1c%*1c%*1c%8f%8f%8f%6f%6f%*1c%*1c%*1c%*1c%*1c%*1c%4c%2c%2c";
//
//    /**
//     * PDB row type.
//     */
//    enum LineType {
//
//        HEADER, DBREF, SEQRES, ATOM, HETATM, MASTER, ENDMDL, OTHER, TER, MODEL, END, CONECT
//    }
//
//    /*
//     * Determine what type of line the argument is.
//     */
//
//    LineType lineType(String line) {
//
//        if (line.isEmpty()) {
//            return LineType.OTHER;
//        }
//        String recordName = line.substring(0, 6).trim();
//
//        if (recordName.equals("DBREF")) {
//            return LineType.DBREF;
//        } else if (recordName.equals("SEQRES")) {
//            return LineType.SEQRES;
//        } else if (recordName.equals("ATOM")) {
//            return LineType.ATOM;
//        } else if (recordName.equals("HETATM")) {
//            return LineType.HETATM;
//        } else if (recordName.equals("MASTER")) {
//            return LineType.MASTER;
//        } else if (recordName.equals("ENDMDL")) {
//            return LineType.ENDMDL;
//        } else if (recordName.equals("END")) {
//            return LineType.END;
//        } else if (recordName.equals("HEADER")	|| recordName.equals("TITLE") 	|| recordName.equals("COMPND") 	|| recordName.equals("SOURCE")
//    		|| recordName.equals("KEYWDS") 	|| recordName.equals("EXPDTA") 	|| recordName.equals("AUTHOR") 	|| recordName.equals("REVDAT")
//    		|| recordName.equals("JRNL") 	|| recordName.equals("REMARK") 	|| recordName.equals("HELIX") 	|| recordName.equals("SHEET")
//    		|| recordName.equals("SITE") 	|| recordName.equals("CRYST1") 	|| recordName.equals("ORIGX1") 	|| recordName.equals("ORIGX2")
//    		|| recordName.equals("ORIGX3") 	|| recordName.equals("SCALE1") 	|| recordName.equals("SCALE2") 	|| recordName.equals("SCALE3")
//    		|| recordName.equals("SEQADV") 	|| recordName.equals("TURN")	|| recordName.equals("FORMUL") 	|| recordName.equals("HETNAM")
//    		|| recordName.equals("SSBOND") 	|| recordName.equals("MODRES") 	|| recordName.equals("CONECT") 	|| recordName.equals("HET")
//                || recordName.equals("CISPEP")) {
//            return LineType.HEADER;
//        } else if (recordName.equals("TER")) {
//            return LineType.TER;
//        } else if (recordName.equals("MODEL")) {
//            return LineType.MODEL;
//        } else {
//            return LineType.OTHER; // Notify error condition.
//        }
//    }
//    // Construct a protein from a PDB file.
//    // Constructor: Constructs a Protein from a PDB file stream.
//    // TODO: (1) Fix the chain id field. (2) Generate proper error messages.
//    //       (3) Set bonds between residues.
//    //       (4) Check whether every field you have scanned while scanning a row is a legal field.
//    //       (5) See if there can be a better implementation for this constructor.
//    public myProtein buildProteinFromPdb(String inputFileName) {
//        myProtein p = new myProtein();
//        try {
//            File inputFile = new File(inputFileName);
//            if (!inputFile.exists()) {
//                System.out.println("Error: Input file " + inputFileName + "is missing");
//                System.exit(1);
//            }
//            BufferedReader input = new BufferedReader(new FileReader(inputFile));
//
//            boolean setResNum = false, extraLine = false;
//            int resNum = 0;
//            char chainId = ' ';
//            Vector<String> block = new Vector<String>();
//            String currLine = null;
//
//            try {
//                while (true) {
//                    if (extraLine) {
//                        extraLine = false;
//                        setResNum = false;
//                    } else {
//                        currLine = input.readLine();
//                        if (currLine == null) {
//                            break;
//                        }
//                        int pad = 80 - currLine.length();
//                        for (int i = 0; i < pad; i++) {
//                            currLine += " ";
//                        }
//                    }
//                    LineType ltype = lineType(currLine);
//
//                    switch (ltype) {
//                        case HEADER:
//                        case DBREF:
//                        case SEQRES:
//                            p.setHeader(p.getHeader() + currLine + '\n');
//                            break;
//                        case TER:
//                        case END:
//                        case MODEL:
//                        case ENDMDL:
//                            break;
//                        default:
//                            System.out.println("Line read: " + currLine);
//                            System.out.println("Error: Invalid line type in the PDB file");
//                            System.exit(1);
//                        case ATOM:
//                            if (!setResNum) { // Set the residue number when you read the first line of the residue
//                                chainId = currLine.charAt(21);
//                                p.setChainId(chainId);
//                                resNum = Integer.parseInt(currLine.substring(22, 26).trim());
//                                setResNum = true;
//                                block.add(currLine);
//                            } else if (Integer.parseInt(currLine.substring(22, 26).trim()) == resNum) { // Second line onwards for the same residue. Check whether the current line represent the same residue.
//                                block.add(currLine);
//                            } else { // The line represents an atom that belongs to a different residue. So unread the line and return the currently read residue block.
//                                extraLine = true;
//                                // Now we have a block of rows read from the PDB file that represents a residue
//                                if (!block.isEmpty()) {
//                                    myResidue r = new myResidue(block);
//                                    p.addResidue(r);
//                                }
//                            }
//                    }
//                }
//            } finally {
//                input.close();
//            }
//        } catch (IOException e) {
//            System.out.println("An IOException is thrown while reading from the input file " + "inputFileName");
//            e.printStackTrace();
//        }
//        p.synchronizeProtein();
//        return p;
//    }
}
