/*
 * This file is part of RDC-ANALYTIC.
 *
 * RDC-ANALYTIC Protein Backbone Structure Determination Software Version 1.0
 * Copyright (C) 2001-2012 Bruce Donald Lab, Duke University
 *
 * RDC-ANALYTIC is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation, either version 3 of the License, or (at your option) any
 * later version.
 *
 * RDC-ANALYTIC is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, see:
 *     <http://www.gnu.org/licenses/>.
 *
 * There are additional restrictions imposed on the use and distribution of this
 * open-source code, including: (A) this header must be included in any
 * modification or extension of the code; (B) you are required to cite our
 * papers in any publications that use this code. The citation for the various
 * different modules of our software, together with a complete list of
 * requirements and restrictions are found in the document license.pdf enclosed
 * with this distribution.
 *
 * Contact Info:
 *     Bruce R. Donald
 *     Duke University
 *     Department of Computer Science
 *     Levine Science Research Center (LSRC)
 *     Durham, NC 27708-0129
 *     USA
 *     email: www.cs.duke.edu/brd/
 *
 * <signature of Bruce Donald>, August 04, 2012
 * Bruce R. Donald, Professor of Computer Science and Biochemistry
 */

/**
 * @version       1.0.1, August 04, 2012
 * @author        Chittaranjan Tripathy (2007-2012)
 * @email         chittu@cs.duke.edu
 * @organization  Duke University
 */

/**
 * Package specification
 */
package analytic;

/**
 * Import statement(s)
 */

/**
 * Description of the class
 */
public class myPair<T, U> implements java.io.Serializable {

    private final T __first;
    private final U __second;

    /**
     * Returns the first element of the pair.
     *
     * @return the first element of the pair
     */
    public T first() {
        return __first;
    }

    /**
     * Return the second element of the pair.
     *
     * @return the second element of the pair
     */
    public U second() {
        return __second;
    }

    /**
     * Constructs a pair with the two elements specified as parameters.
     *
     * @param first the first element of the pair
     * @param second the second element of the pair
     */
    public myPair(final T first, final U second) {
        this.__first = first;
        this.__second = second;
    }

    /**
     * Constructs a pair with the two elements specified as parameters.
     *
     * @param <T1> type of the first element of the pair
     * @param <T2> type of the second element of the pair
     * @param first the first element of the pair
     * @param second the second element of the pair
     * @return
     */
    public static <T1, T2> myPair<T1, T2> makePair(T1 first, T2 second) {
        return new myPair<T1, T2>(first, second);
    }

    /**
     * Compares object in the argument with this object for equality.
     *
     * @param o the Object to be compared for equality with this object
     * @return true if the specified Object is equal to this object
     */
    @Override public boolean equals(Object o) {
        if (!(o instanceof myPair))
            return false;

        final myPair<?, ?> other = (myPair) o;
        return equal(first(), other.first()) && equal(second(), other.second());
    }

    /**
     * Compares the two objects for equality.
     * @param o1 the first object
     * @param o2 the second object
     * @return true if the two objects are equal
     */
    public static boolean equal(Object o1, Object o2) {
        if (o1 == null) {
            return o2 == null;
        }
        return o1.equals(o2);
    }

    /**
     * Return the hash code value for this pair.
     *
     * @return the hash code value for this pair
     */
    @Override public int hashCode() {
        int hFirst = first() == null ? 0 : first().hashCode();
        int hSecond = second() == null ? 0 : second().hashCode();
        return hFirst + (31 * hSecond);
    }

    public static void main(String... args) {
        System.out.println("Hello World! Testing myPair<T, U>");
    }
}
