/*
 * This file is part of RDC-ANALYTIC.
 *
 * RDC-ANALYTIC Protein Backbone Structure Determination Software Version 1.0
 * Copyright (C) 2001-2009 Bruce Donald Lab, Duke University
 *
 * RDC-ANALYTIC is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation, either version 3 of the License, or (at your option) any
 * later version.
 *
 * RDC-ANALYTIC is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, see:
 *     <http://www.gnu.org/licenses/>.
 *
 * There are additional restrictions imposed on the use and distribution of this
 * open-source code, including: (A) this header must be included in any
 * modification or extension of the code; (B) you are required to cite our
 * papers in any publications that use this code. The citation for the various
 * different modules of our software, together with a complete list of
 * requirements and restrictions are found in the document license.pdf enclosed
 * with this distribution.
 *
 * Contact Info:
 *     Bruce R. Donald
 *     Duke University
 *     Department of Computer Science
 *     Levine Science Research Center (LSRC)
 *     Durham, NC 27708-0129
 *     USA
 *     email: www.cs.duke.edu/brd/
 *
 * <signature of Bruce Donald>, 01 December, 2009
 * Bruce R. Donald, Professor of Computer Science and Biochemistry
 */

/**
 * @version       1.0.0, Nov 18, 2009
 * @author        Chittaranjan Tripathy (2007-2009)
 * @email         chittu@cs.duke.edu
 * @organization  Duke University
 */

/**
 * Package specification
 */
package analytic;

/**
 * Import statement(s)
 */

/**
 * Description of the class
 */
public class myTriple<T1, T2, T3> implements java.io.Serializable {

    private final T1 __first;
    private final T2 __second;
    private final T3 __third;  

    /**
     * Returns the first element.
     *
     * @return the first element
     */
    public T1 first() {
        return __first;
    }

    /**
     * Return the second element.
     *
     * @return the second element
     */
    public T2 second() {
        return __second;
    }

    /**
     * Returns the third element.
     *
     * @return the third element
     */
    public T3 third() {
        return __third;
    }

    /**
     * Constructs a triple with the four elements specified as parameters.
     *
     * @param first the first element
     * @param second the second element
     * @param third the third element
     */
    public myTriple(final T1 first, final T2 second, final T3 third) {
        this.__first = first;
        this.__second = second;
        this.__third = third;        
    }

    /**
     * Constructs a triple with the four elements specified as parameters.
     *
     * @param <T1> the type of first element
     * @param <T2> the type of second element
     * @param <T3> the type of third element
     * @param first the first element
     * @param second the second element
     * @param third the third element
     * @return a triple object
     */
    public static <T1, T2, T3> myTriple<T1, T2, T3> makeTriple(T1 first, T2 second, T3 third) {
        return new myTriple<T1, T2, T3>(first, second, third);
    }
//
//    /**
//     * Compares object in the argument with this object for equality.
//     *
//     * @param o the Object to be compared for equality with this object
//     * @return true if the specified Object is equal to this object
//     */
//    @Override public boolean equals(Object o) {
//        if (!(o instanceof myPair))
//            return false;
//
//        final myPair<?, ?> other = (myPair) o;
//        return equal(first(), other.first()) && equal(second(), other.second());
//    }
//
//    /**
//     * Compares the two objects for equality.
//     * @param o1 the first object
//     * @param o2 the second object
//     * @return true if the two objects are equal
//     */
//    public static boolean equal(Object o1, Object o2) {
//        if (o1 == null) {
//            return o2 == null;
//        }
//        return o1.equals(o2);
//    }
//
//    /**
//     * Return the hash code value for this pair.
//     *
//     * @return the hash code value for this pair
//     */
//    @Override public int hashCode() {
//        int hFirst = first() == null ? 0 : first().hashCode();
//        int hSecond = second() == null ? 0 : second().hashCode();
//        return hFirst + (31 * hSecond);
//    }
//
    public static void main(String... args) {
        System.out.println("Hello World! Testing myTriple<T1, T2, T3>");
    }
}
